/**
 *  @file game/Decider.h
 *  IDecider interface.
 */
#ifndef __DECIDER_H
#define __DECIDER_H


class CMyEntity;

/**
 *  Entity decider (AI) interface.
 *
 *  Entity logic happens through it's decider - each entity has a
 *  decider that gets called at some times (based on counter). A
 *  decider should do entity logic (eg. alter it's velocity, size,
 *  color, sprite, kill it) and set a new counter value.
 *
 *  Deciders can be shared accross many entities.
 *
 *  @see CGameEntity.
 */
class IDecider {
public:
	virtual ~IDecider() { }

	/**
	 *  Perform logic for an entity.
	 *  @param e The entity.
	 */
	virtual void decideFor( CMyEntity& e ) const = 0;
};


class PuppyDecider : public IDecider
{
public:
	~PuppyDecider () { }
	void decideFor( CMyEntity& e) const;
private:
};

class FactoryDecider : public IDecider
{
public:
	~FactoryDecider () { }
	void decideFor( CMyEntity& e) const;
private:
};

class FlagDecider : public IDecider
{
public:
	~FlagDecider () { }
	void decideFor( CFlagEntity& e) const;
	void decideFor(CMyEntity& e) const;

private:
};

#endif
