/**
 * @file game/GameConstants.h
 * Engine related constants.
 * Set up now for default values, change if you like (but with great care).
 */

#ifndef __ENGINE_CONSTANTS_H
#define __ENGINE_CONSTANTS_H

//#include <tchar.h>


/** Global engine constants namespace. */
namespace gcon {

	// --------------------------------------------------------------
	//  general

	const float EPSILON = 0.0001f;

	/**
	 *  Game window title.
	 */
//	static TCHAR* WINDOW_TITLE = _T("GameJam'02 - FooGame by FooCoder");
	static char* WINDOW_TITLE = "GameJam'02 - FooGame by FooCoder";

	// --------------------------------------------------------------
	//  game

	/**
	 *  Game updates frequency.
	 *  Game logic happens at a fixed rate per second. Rendering takes
	 *  all the time that is left from the logic (so the longer your
	 *  logic, the less FPS you get).
	 */
	const int	UPDATE_FREQ = 20;
	const float UPDATE_DT = 1.0f / UPDATE_FREQ;

	/**
	 *  Gravity for entities.
	 *  Engine subtracts this from vertical entity's velocity every game
	 *  update (NOT second).
	 */
	const float GRAVITY = 0.6f;


	// --------------------------------------------------------------
	//  world size

	/**
	 *  World size in X direction.
	 *  <B>Must be a power of 2</B>. All world-related X coordinates
	 *  must be in range [0..WORLD_X) - WORLD_X is already not a valid
	 *  coordinate.
	 */
	const int WORLD_X = 1024; // must be 2^n
	/**
	 *  World size in Y direction.
	 *  <B>Must be a power of 2</B>. All world-related Y coordinates
	 *  must be in range [0..WORLD_Y) - WORLD_Y is already not a valid
	 *  coordinate.
	 */
	const int WORLD_Y = 1024; // must be 2^n
	

}; // namespace gcon

#endif

