
#ifndef __FLAG_ENTITY_H__
#define __FLAG_ENTITY_H__



/**
 *  @file game/MyEntity.h
 *  Your game entity.
 */

#define NONE_SECTOR -1

#include <d3dx8math.h>

#include "../engine/Entity.h"
#include "../engine/animator/Animator.h"
#include "../engine/Grid.h"


class IDecider;
class FlagDecider;

#pragma pack(1)

//


/**
 *  Your game entity.
 */

class CFlagEntity : public CEntity {
public:
	enum {
		F_KEEP_ON_TERRAIN = 1,
		F_GRAVITY = 2,
		F_TOUCHES_TERRAIN = 4,
		F_KILLED = 8
	};
	enum { DEFAULT_DECIDER_COUNTER = 50 };
	enum {
		FT_ATTRACT = 1,
		FT_PUSH	= 2
	};
	enum {
		ACT_CREATE = 1,
		ACT_DESTROY = 2,
		ACT_NONE = 3
	};

public:
	void	init( D3DXVECTOR3 &v );		// coordinates on terrain
	void	update();

	D3DXVECTOR3& getFlagPos () { return mFlagPos; };

	static CFlagEntity* create ( D3DXVECTOR3 &origin, D3DXVECTOR3 &dir );

public:
	D3DXVECTOR3	mVelocity;
	short		mFlags;
	short		mAction;
	short		mDeciderCounter;
	FlagDecider*	mDecider;
    short		mSectorNumber;		// say, -1 for "none"
    short		mIndexInSector;
	D3DXVECTOR3	mFlagPos;			// note, that z is undefined -- it means nothing and may be anything. ignore it
	short		mTeam;
	short		mType;
	short		mAge;

	CAnimator<2.0f>	mAnimator;
private:
	void removeFromOldSector();
	void insertIntoSector(int newSectorIndex);
};

#pragma pack()


#endif		// #ifndef __FLAG_ENTITY_H__
