
#include "FlagEntity.h"

#include "Decider.h"
#include "MyGame.h"
#include "../engine/Terrain.h"
#include "../engine/TerrainPicker.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"

#include <cassert>



void	CFlagEntity::init( D3DXVECTOR3 &v )		// coordinates on terrain
//void CFlagEntity::init( double x, double y )	// coordinates on terrain
{
	mAge=0;
	mVelocity.x = 0.0f;
	mVelocity.y = 0.0f;
	mVelocity.z = 0.0f;
	
	mAnimator.init( 
		CMyGame::getInstance().getAnimationSet(),
		CMyGame::getInstance().getHackFrameTimeForAnimation() );
	mSectorNumber= NONE_SECTOR;

	mFlagPos = v;
//	mType = 0;
}

void CFlagEntity::removeFromOldSector()
{
}

void CFlagEntity::insertIntoSector(int newSectorIndex)
{
}

void CFlagEntity::update()
{
	//
	// set old position

//	getOldPosition() = getPosition();

	//
	// decide (AI)

	if( mDecider ) {
		if( !mDeciderCounter ) {
			mDeciderCounter = DEFAULT_DECIDER_COUNTER;
			mDecider->decideFor( *this );
		}
		--mDeciderCounter;
	}

//	int newSectorNumber = CMyGame::getInstance().grid->position2Index( getPosition().x, getPosition().y );
//	if( mSectorNumber != newSectorNumber ) {
//		removeFromOldSector();
//		insertIntoSector( newSectorNumber );
//	}

	//
	// terrain height
/*	getPosition() = mFlagPos;
	getOldPosition() = getPosition();
	
	D3DXVECTOR3 pos = getPosition();
	float h = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();

	if( mFlags & F_KEEP_ON_TERRAIN ) {
		pos.z = h;
	} else {
		if( mFlags & F_GRAVITY ) {
			mVelocity.z -= gcon::GRAVITY;
		}
		if( pos.z < h ) {
			pos.z = h;
			mVelocity.z = 0.0f; // TODO: bounce off?
		}
	}

//	pos.x += mVelocity.x;
//	pos.y += mVelocity.y;
	pos.z += mVelocity.z;

	if( pos.z <= h )
		mFlags |= F_TOUCHES_TERRAIN;
	else
		mFlags &= ~F_TOUCHES_TERRAIN;

	getPosition() = pos;
	mFlagPos = getPosition();*/
}



/*
*/
CFlagEntity* CFlagEntity::create ( D3DXVECTOR3 &origin, D3DXVECTOR3 &dir )
{
	D3DXVECTOR3		point;
	CFlagEntity		*e;

	CTerrainPick pick = CTerrainPicker::pick( CMyGame::getInstance().getTerrain(), origin, dir );
	if( pick.isValid() )
	{
		e = new CFlagEntity;
		point = pick.getLocation ();
		e->getFlagPos() = point;
		e->getFlagPos().z += 20.25;
		e->mFlags = 0;
//		e->mFlags |= F_KEEP_ON_TERRAIN;
		e->mFlags |= F_GRAVITY;

		return e;
    }

//	assert ( !"Shit happens! Nepataikei i terraina! :)" );

	return NULL;
}

