
#ifndef __MES_ENTITY_H__
#define __MES_ENTITY_H__


#include <d3dx8math.h>

#include "../engine/Entity.h"
// #include "../engine/animator/Animator.h"


struct SPreciseSector {
   enum { MIN_CAPACITY = 16 }; // minimum capacity
   SPreciseSector();
   ~SPreciseSector();
   void    increaseCapacity(); // allocate bigger array, copy old data
   void    decreaseCapacity(); // allocate smaller array, copy old data
   
   int         mCapacity; // capacity of array
   int         mCount;    // entity count
   int 		   
   CEntity**   mEntities; // array of pointers to entitites
};

typedef CGrid<SPreciseSector> TPreciseSectorGrid;


class MesEntity : public CEntity
{
public:
		MesEntity ();
		~MesEntity ();

		enum MONSTERTYPES
		{
				DUST_PUPPY = 0,
				CRUD_PUPPY,

				NUM_MONSTERTYPES
		};

private:
		D3DXVECTOR3		velocity;
		short mSectorNumber;
		short mIndexInSector;
};


#endif		// #ifndef __MES_ENTITY_H__
