#include "MyEntity.h"

#include "Decider.h"
#include "MyGame.h"
#include "../engine/Terrain.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"


void CMyEntity::init()
{
	/*mAnimator.init( 
		CMyGame::getInstance().getAnimationSet(),
		CMyGame::getInstance().getHackFrameTimeForAnimation() );*/
	mSectorNumber= NONE_SECTOR;
}

void CMyEntity::removeFromOldSector()
{
	if ( NONE_SECTOR == mSectorNumber )
        return;
    // get sector
    SPreciseSector& s = CMyGame::getInstance().grid->getSectorByIndex( mSectorNumber );
    int o = mIndexInSector;
    assert( s.mEntities[o] == this ); // just in case
    int lastIndex = --s.mCount;
    if( lastIndex != o ) { // if we're not last
        // place last one into our place
        s.mEntities[o] = s.mEntities[lastIndex];
        s.mEntities[o]->mIndexInSector = o; // update last one's index
    }
    if( s.mCount * 2 <= s.mCapacity ) // like this
        s.decreaseCapacity();
    mSectorNumber = NONE_SECTOR;
}

void CMyEntity::insertIntoSector(int newSectorIndex)
{
    // get sector
    SPreciseSector& s = CMyGame::getInstance().grid->getSectorByIndex( newSectorIndex );
    if( s.mCount >= s.mCapacity )
        s.increaseCapacity();
    assert( s.mCount < s.mCapacity ); // just in case
    // put at end of entity list
    int o = s.mCount++;
    s.mEntities[o] = this;
    mSectorNumber = newSectorIndex;
    mIndexInSector = o;
}

void CMyEntity::update()
{

	//
	// set old position

	getOldPosition() = getPosition();

	//
	// decide (AI)

	if( mDecider ) {
		if( !mDeciderCounter ) {
			mDeciderCounter = DEFAULT_DECIDER_COUNTER;
			mDecider->decideFor( *this );
		}
		--mDeciderCounter;
	}

	D3DXVECTOR3 pos = getPosition() + mVelocity;

	int newSectorNumber = CMyGame::getInstance().grid->position2Index( getPosition().x, getPosition().y );
    if( mSectorNumber != newSectorNumber ) {
        removeFromOldSector();
        insertIntoSector( newSectorNumber );
    }

	//
	// bound to world

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
	}

	//
	// TODO: buildings

	//
	// terrain height

	float h = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();

	if( mFlags & F_KEEP_ON_TERRAIN ) {
		pos.z = h;
	} else {
		if( mFlags & F_GRAVITY ) {
			mVelocity.z -= gcon::GRAVITY;
		}
		if( pos.z < h ) {
			pos.z = h;
			mVelocity.z = 0.0f; // TODO: bounce off?
		}
	}

	if( pos.z <= h )
		mFlags |= F_TOUCHES_TERRAIN;
	else
		mFlags &= ~F_TOUCHES_TERRAIN;

	//setPicture( mAnimator.getPicture() );

	getPosition() = pos;
}