/**
 *  @file game/MyEntity.h
 *  Your game entity.
 */

#ifndef __GAME_ENTITY_H
#define __GAME_ENTITY_H

#define NONE_SECTOR -1

#include <d3dx8math.h>

#include "../engine/Entity.h"
#include "../engine/animator/Animator.h"
#include "../engine/Grid.h"

#include <vector>


class IDecider;
class CFlagEntity;

#pragma pack(1)

//


/**
 *  Your game entity.
 */

class CMyEntity : public CEntity {
public:
	enum {
		F_KEEP_ON_TERRAIN = 1,
		F_GRAVITY = 2,
		F_TOUCHES_TERRAIN = 4,
		F_KILLED = 8
	};
	enum { DEFAULT_DECIDER_COUNTER = 50 };

public:
	void	init();
	void	update();
	
public:
	D3DXVECTOR3	mVelocity;
	short		mFlags;
	short		mDeciderCounter;
	IDecider*	mDecider;
    short		mSectorNumber; // say, -1 for "none"
    short		mIndexInSector;
	short		mTeam;
	std::vector<CFlagEntity *> mWorkingFlags;

	CAnimator<2.0f>	mAnimator;
private:
	void removeFromOldSector();
	void insertIntoSector(int newSectorIndex);
};

#pragma pack()

#endif
