#pragma warning(disable:4786)

#include "MyGame.h"
#include "FlagEntity.h"
#include "../engine/EntityRenderer.h"
#include "../engine/Mesh.h"
#include "../engine/Terrain.h"
#include "../engine/TerrainGen.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/resource/PictureBundle.h"
#include "../engine/EntityRayPicker.h"
#include "../utils/Config.h"

//#include "../engine/TerrainPicker.h"
#include "../engine/TextRenderer.h"

// ENGINE CONSTANTS
#include "PreciseSector.h"
#include "EngineConstants.h"
#include "../utils/Random.h"
#include "decider.h"
#include "netlib/Network.h"

#include <string>
//using namespace std;

#include <cstring>
#include <cassert>


// ------------------------------------------------------------------
//  basic stuff


CMyGame::CMyGame( CConfig& config )
:	CBaseGame( config ),
	mTerrainCamera( NULL ),
	mPool( NULL ),
	mId ( (unsigned)-1 ),
	mTick ( 1 ),
	clientCount ( 0 ),
	mNewFlag ( NULL )
{
	grid = new TPreciseSectorGrid;
	bodycount = 0;
	Network::init();
	dec = new FlagDecider;
}

CMyGame::~CMyGame()
{
	delete mPool;
}

CCamera* CMyGame::createCamera()
{
	mTerrainCamera = new CBasicCamera();
	mTerrainCamera->getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, 100.0f );

	return mTerrainCamera;
}





/*
==================================================================
		All clickers (a.k.a. input :)))
		
   Shichia pasiimam visokius inputus ir darom viska visaip.
   In particular:
   (o) "Creatinam" flagus ir kisham juos i new_flags containeri
   (o) "Naikinam" nereikalingus flagus ir dedam juos i toremove_flags
   Visi realus baleko sukurimai/naikinimai gali buti atlikti tik gavus
   cofirmationa ish networko, todel viskas ir yra grudama i tarpinius
   konteinerius -- veliau viskas bus siunchiama servui ir bus laukiama
   realaus sunaikinimo komandos.
   
==================================================================
*/


/*
==================================================================
	handlina eventa, pribindinta prie kairaus mauzo klavisho.
 Realiausia, kad tai bus flago creatinimas.
==================================================================
*/
void CMyGame::onMouseLChange( bool pressed )
{
	if ( pressed )
	{
		D3DXVECTOR3 origin = getCamera().getPosition();
		D3DXVECTOR3 dir = getCamera().getWorldRay( getMouse().getMouseX(), getMouse().getMouseY() );

		CFlagEntity *f;
		f = CFlagEntity::create ( origin, dir );
		if ( NULL != f )
		{
			mNewFlag = f;
			CONSOLE << "Adding flag..." << con::endl;
			
			CPictureBundle& pb = CPictureBundle::getInstance();
			const CPicture& pic = *pb.getResourceById( CResourceId("flag.png") );
			

			getEntities().add( *f );
			f->mType = CFlagEntity::FT_ATTRACT;
			f->mTeam = CMyGame::getInstance().mId;
			f->mAction = CFlagEntity::ACT_CREATE;
			f->getPosition() = f->getFlagPos();
			//		f->getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
			//		f->mVelocity = D3DXVECTOR3( random::randfs(1.0f), random::randf(1.0f), 0.0f );
			f->getOldPosition() = f->getPosition();
			//		f->mDeciderCounter = 1;
			//		f->mDecider = dec;
			f->setPicture( pic );
			f->setSize( 5.0f );
			f->setColor( 0xFFFFFFFF );
			//		f->mFlags = CMyEntity::F_GRAVITY;
			f->init( f->getPosition() );
		}
	}
}


/*
==================================================================
	handlina eventa, pribindinta prie deshinaus mauzo klavisho.
 Realiausia, kad tai bus flago naikinimas.
==================================================================
*/
void CMyGame::onMouseRChange( bool pressed )
{
	if ( pressed )
	{
		D3DXVECTOR3 origin = getCamera().getPosition();
		D3DXVECTOR3 dir = getCamera().getWorldRay( getMouse().getMouseX(), getMouse().getMouseY() );

		CFlagEntity *f;
		f = CFlagEntity::create ( origin, dir );
		if ( NULL != f )
		{
			mNewFlag = f;
			CONSOLE << "Adding flag..." << con::endl;
			
			CPictureBundle& pb = CPictureBundle::getInstance();
			const CPicture& pic = *pb.getResourceById( CResourceId("flag2.png") );
			
			getEntities().add( *f );
			f->mType = CFlagEntity::FT_PUSH;
			f->mTeam = CMyGame::getInstance().mId;
			f->mAction = CFlagEntity::ACT_CREATE;
			f->getPosition() = f->getFlagPos();
			//		f->getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
			//		f->mVelocity = D3DXVECTOR3( random::randfs(1.0f), random::randf(1.0f), 0.0f );
			f->getOldPosition() = f->getPosition();
			f->setPicture( pic );
			f->setSize( 5.0f );
			f->setColor( 0xFFFFFFFF );
			//		f->mFlags = CMyEntity::F_GRAVITY;
			f->init( f->getPosition() );
		}
	}
}


/*
========================
	Nu visokiu klaviniu eventu specialusis handlinimas. Naturalu.
========================
*/
void CMyGame::onKeyChange( int key, bool pressed )
{
}



/*
============================================================
rtfb:
-----
  Neblogai butu processinti kokitaiten Esc. Dar geriau butu minimalus meniu, bet chia px.
============================================================
*/
/*
===============
general klaviniu eventu handlinimas.

FIXME:
o gal ir mauzas chia kazhkur handlinasi?
===============
*/
void CMyGame::onProcessInput()
{
	assert( mTerrainCamera );

	// update rotation from keys
	if( getKeyboard().isKeyPressed(VK_UP) )		mTerrainCamera->doPitch( 0.05f );
	if( getKeyboard().isKeyPressed(VK_DOWN) )	mTerrainCamera->doPitch( -0.05f );
	if( getKeyboard().isKeyPressed(VK_LEFT) )	mTerrainCamera->doYaw( 0.05f );
	if( getKeyboard().isKeyPressed(VK_RIGHT) )	mTerrainCamera->doYaw( -0.05f );
	if( getKeyboard().isKeyPressed('S') )		mTerrainCamera->doMove( 70.0f );
	if( getKeyboard().isKeyPressed('X') )		mTerrainCamera->doMove( -70.0f );
	if( getKeyboard().isKeyPressed('Z') )		mTerrainCamera->doStrafe( -40.0f );
	if( getKeyboard().isKeyPressed('C') )		mTerrainCamera->doStrafe( 40.0f );
	if( getKeyboard().isKeyPressed('Q') )		mTerrainCamera->doRise( 40.0f );
	if( getKeyboard().isKeyPressed('A') )		mTerrainCamera->doRise( -40.0f );
}


// ------------------------------------------------------------------
//  initialization


void CMyGame::onInitialize()
{
//
// connect to server
//
	std::string server = getConfig().readS( "game", "server", "127.0.0.1" );
	CONSOLE << "Connecting to server " << server << con::endl;
	network.connect( server, 7778);
	network.sendReady();

	while (!network.receiveReadyAll(mId, clientCount) );
//	mId = 1;
	CONSOLE << "Got ID=" << mId << " from server..." << con::endl;

//
// init terrain
//	
	mTerrainCamera->setTerrain( getTerrain() );
	CONSOLE << "Terrain done ..." << con::endl;


//
// create all pools here
//
	int maxEntities = getEntities().getMaxEntities();
	mPool = new TPool( maxEntities );
	mFlagPool = new TFlagPool ( 128 );
	mCreatedFalgsPool = new TFlagPool ( 128 );
	mDeletedFlagsPool = new TFlagPool ( 128 );
	CONSOLE << "Pools done ..." << con::endl;


//
// other stuff
//
	CPictureBundle& pb = CPictureBundle::getInstance();
	const CPicture& pic1 = *pb.getResourceById( CResourceId("dust.png") );
	const CPicture& pic2 = *pb.getResourceById( CResourceId("god.png") );
	
	CTerrainGen::fillTexture( getTerrain(), CResourceId("TerrainGray.png"), -50.0f, 100.0f );

	int count = maxEntities/2;

	IDecider *dec = new PuppyDecider();

	int i;
	for( i = 0; i < count; ++i ) {
		CMyEntity& e = mPool->add();
		getEntities().add( e );
		e.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		e.mVelocity = D3DXVECTOR3( random::randfs(1.0f) - 0.5f, random::randf(1.0f) -0.5f, 0.0f );
		e.getOldPosition() = e.getPosition();
		if (i%2) e.mTeam = CMyGame::getInstance().mId;
			else e.mTeam = (CMyGame::getInstance().mId + 1) % 2;
		e.mDeciderCounter = 1;
		e.mDecider = dec;
		if (e.mTeam == CMyGame::getInstance().mId)	e.setPicture( pic1 );
			else e.setPicture( pic2 );
		e.setSize( 1.0f );
		e.setColor( 0xFFFFFFFF );
		e.mFlags = CMyEntity::F_GRAVITY;
		e.init();
	}
	CONSOLE << "Other stuff Done  ..." << con::endl;
	/*
	const CPicture& p1 = *pb.getResourceById( CResourceId("dust.png") );
	const CPicture& p2 = *pb.getResourceById( CResourceId("dust.png") );
	const CPicture& p3 = *pb.getResourceById( CResourceId("dust.png") );

	mAnimationSet.add( p1 );
	mAnimationSet.add( p2 );
	mAnimationSet.add( p3 );
	*/

/*	static CMesh* mesh = new CMesh( 
		CResourceId( "cone10atzero.x" ),
		CResourceId( "TexturedMesh.sha" ),
		CResourceId( "TerrainGray.png" ) );
	mesh->getWorldMatrix()._11 = 10;
	mesh->getWorldMatrix()._22 = 10;
	mesh->getWorldMatrix()._33 = 20;
	mesh->getWorldMatrix()._41 = 300;
	mesh->getWorldMatrix()._42 = 400;*/

//	getObjects().addObject( *mesh );
}


// ------------------------------------------------------------------
//  game logic


/*
===================================================
rtfb:
-----
			Taip, game logic :)

    1. Pirmiausia chai yra susiunchiama visokia info servui.     
    2. Parsisrebiama info ish servo.
    3. Suveikia faktoriu decisionai -- spawninami nauji puppiai.
    4. Regis chia turetu buti entichiu updateris, bet kadangi su tuo
    tvarkosi enginas, tai mes tikriausiai bbd ir ties chia ir baigiam.
    Jeigu dar ko prireix, tai bilekada pridesim.
===================================================
*/
void CMyGame::onUpdate()
{
		sendToServer ();
		receiveFromServer ();

		updateEntities();
		mTick++;
}




/*bool CMyGame::RayHitFlag ( D3DXVECTOR3 &origin, D3DXVECTOR3 &dir )
{
		CEntityRayPicker<TEntityPickerGrid>	picker;
		TFlagPool::iterator						it;

		picker.putRay(EntityPickerGrid, origin, dir );

		for (	it  = mFlagPool->begin();
				it != mFlagPool->end(); )
		{
			if ( picker.intersects(*(*it), EntityPickerGrid.getSectorByIndex(0) ))
			{
				// TODO: put actual removing of flags here.
				mNewFlag = *it;
				mNewFlag->mAction = CFlagEntity::ACT_DESTROY;
				mNewFlag->mDeciderCounter = it.getIndex();
				return true;
			}
			++it;
		}
} */




void CMyGame::updateEntities ()
{

	TFlagPool::iterator i;

	for ( i = mFlagPool->begin (); i != mFlagPool->end();  )
	{
		CFlagEntity *f = *i;
		f->update();

		if ( f->mFlags & CFlagEntity::F_KILLED )
		{
//				delete *i;
				i = mFlagPool->erase( i );
				getEntities().remove ( *f );
		} else {
			++i;
		}
	}

	// update entities
	TPool::iterator it;
	for( it = mPool->begin(); it != mPool->end();  ) {
		CMyEntity& e = *it;
		assert( e.mDeciderCounter >= 0 );
		e.update();
		if( e.mFlags & CMyEntity::F_KILLED ) {
			it = mPool->erase( it );
			getEntities().remove( e );
		} else {
			++it;
		}
	}

	if (!mDeletedFlagsPool->empty()) mDeletedFlagsPool->clear();
	if (!mCreatedFalgsPool->empty()) mCreatedFalgsPool->clear();


	mAnimationSet.update( getHackFrameTimeForAnimation() );
}



void CMyGame::sendToServer ()
{
	NetData					data;

	if ( mNewFlag )
	{
			data.mAction = mNewFlag->mAction;
			data.mFlagPos = mNewFlag->getPosition ();
			data.mFlags = mNewFlag->mFlags;
			data.mType = mNewFlag->mType;
			data.mTeam = mNewFlag->mTeam;
			CONSOLE << "Sending flag from team " << mNewFlag->mTeam << con::endl;
			data.foo = CFlagEntity::ACT_CREATE;

			network.sendTick( mTick, &data);
			mNewFlag = NULL;
	}
	else
	{
		data.mAction = CFlagEntity::ACT_NONE;
		data.foo = CFlagEntity::ACT_NONE;
		network.sendTick( mTick, &data );
	}
}



void CMyGame::receiveFromServer ()
{
	NetData		dataFromNet[32];
	int			i;

//	mCreatedFalgsPool->clear();
	unsigned long newTick;
	if ( network.receiveTick( newTick, dataFromNet, clientCount) )
	{
		for (i=0; i<clientCount; i++)
		{
			switch ( dataFromNet[i].mAction )
			{
				case CFlagEntity::ACT_CREATE:
				{
					CFlagEntity		*e = new CFlagEntity;
//					FlagDecider *dec = new FlagDecider();
					e->mFlagPos = dataFromNet[i].mFlagPos;
					e->mFlags = dataFromNet[i].mFlags;
					e->mType = dataFromNet[i].mType;
					e->mTeam = dataFromNet[i].mTeam;
					e->mDecider = dec;
					e->mDeciderCounter = 1;
					e->mAge = 0;

					CONSOLE << "Got flag from team " << e->mTeam << "!" << con::endl;
					mFlagPool->add( e );
					mCreatedFalgsPool->add( e );

					break;
				}
				
				case CFlagEntity::ACT_DESTROY:
				{
					// TODO: wazza
//					mDeletedFlagsPool->add(mFlagPool->)
//					moo;
					break;
				}
				
				case CFlagEntity::ACT_NONE:
				{
					break;
				}
			}
		}
	}
//	mTick = newTick;
}


/*
=======================================================================
		rendering
		
 Na mes regis ant shito nieko svarbaus nekabinsim. Reikes tik onRenderAfterAll supaishyti
 visokius textus ir kitoki funky bruda.
=======================================================================
*/

void CMyGame::onRenderBeforeAll()
{
}

void CMyGame::onRenderAfterWorld()
{
}

void CMyGame::onRenderAfterAll()
{
	int		numents;
	char	zzz[1024];
	char	str[32];

	numents = getEntities().getEntityCount();
	strcpy ( zzz, "Number of entities: " );
	sprintf ( str, "%d", numents );
	strcat ( zzz, str );
	getTextRenderer().renderScreenText( 10, 20, std::string (zzz), 0x80FFFF00 );
	numents = mFlagPool->size();
	strcpy ( zzz, "Number of flags: " );
	sprintf ( str, "%d", numents );
	strcat ( zzz, str );
	getTextRenderer().renderScreenText( 10, 40, std::string (zzz), 0x80FFFF00 );
	numents = bodycount;
	strcpy ( zzz, "He has: " );
	sprintf ( str, "%d", 750 - numents );
	strcat ( zzz, str );
	getTextRenderer().renderScreenText( 10, 60, std::string (zzz), 0x80FFFF00 );
	strcpy ( zzz, "You have: " );
	sprintf ( str, "%d", getEntities().getEntityCount() - 750 + numents );
	strcat ( zzz, str );
	getTextRenderer().renderScreenText( 10, 80, std::string (zzz), 0x80FFFF00 );
}
