/**
 *  @file game/MyGame.h
 *  Your game application code.
 */

#ifndef __MY_GAME_H
#define __MY_GAME_H

#include "MyEntity.h"
#include "FlagEntity.h"
#include "../engine/BaseGame.h"
#include "../utils/FixedPool.h"
#include "../utils/Singleton.h"

#include "../engine/animator/AnimationSet.h"
#include "../engine/console/Console.h"

#include "PreciseSector.h"
#include "netlib/Network.h"
#include <d3dx8math.h>


static con::CChannel& CONSOLE = con::CConsole::getChannel("channel");


class FlagDecider;


class CBasicCamera;
/**
 *  Your game application class.
 */
class CMyGame : public CBaseGame, public CSingleton<CMyGame>
{
public:

public:
	typedef CFixedPool<CMyEntity>		TPool;
	typedef CFixedPool<CFlagEntity*>		TFlagPool;

public:
	static void init( CConfig& config ) {
		CMyGame* game = new CMyGame( config ); assert( game );
		assignInstance( *game );
	}
	virtual ~CMyGame();

	CAnimationSet const& getAnimationSet() { return mAnimationSet; }

protected:
	/// Receive left mouse button change.
	virtual void	onMouseLChange( bool pressed );
	/// Receive right mouse button change.
	virtual void	onMouseRChange( bool pressed );
	/// Receive key state change.
	virtual void	onKeyChange( int key, bool pressed );
	
	/**
	 *  Initialize the game.
	 */
	virtual	void onInitialize();
	
	/**
	 *  Process input.
	 *  The engine calls this method for processing input.
	 */
	virtual void onProcessInput();

	/**
	 *  Execute game logic.
	 *  The engine calls this method when game update time comes.
	 */
	virtual void onUpdate();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method before rendering anything.
	 */
	virtual void onRenderBeforeAll();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering all world
	 *  objects.
	 */
	virtual void onRenderAfterWorld();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering everything.
	 */
	virtual void onRenderAfterAll();


protected:
	virtual CCamera* createCamera();

private:
	CMyGame( CConfig& config );

	static CMyGame* createInstance() {
		assert( !"Must be initialized first" );
		return 0;
	}

	static void deleteInstance( CMyGame& instance ) {
		delete &instance;
	}

	friend CSingleton<CMyGame>;
	void updateEntities ();
	void sendToServer ();
	void receiveFromServer ();
	bool RayHitFlag ( D3DXVECTOR3 &origin, D3DXVECTOR3 &dir );



private:
	CBasicCamera*	mTerrainCamera;

	CAnimationSet	mAnimationSet;

public:
	TPool*			mPool;

	TFlagPool*		mFlagPool;			// qzma
	CFlagEntity		*mNewFlag;

	TFlagPool*		mCreatedFalgsPool;	// qzma
	TFlagPool*		mDeletedFlagsPool;	// qzma
	int bodycount;

	TPreciseSectorGrid* grid;
	unsigned long   mId;
	unsigned long	mTick;
	unsigned long   clientCount;

	FlagDecider		*dec;

	Network network;
};

#endif
