#ifndef __PRECISE_SECTOR_H
#define __PRECISE_SECTOR_H

#define GRID_SIZE 128

#include "../engine/Grid.h"
#include <vector>
class CMyEntity;


struct SPreciseSector {
   enum { MIN_CAPACITY = 16 }; // minimum capacity
   SPreciseSector();
   ~SPreciseSector();
   void    increaseCapacity(); // allocate bigger array, copy old data
   void    decreaseCapacity(); // allocate smaller array, copy old data
   
   int         mCapacity; // capacity of array
   int         mCount;    // entity count
   std::vector<CMyEntity *> mEntities;
//   CMyEntity**   mEntities; // array of pointers to entitites
};

typedef CGrid<SPreciseSector,GRID_SIZE,GRID_SIZE>   TPreciseSectorGrid;



struct SEntityPickerSector
{
	bool		mHasRay;
	D3DXVECTOR3	mOrigin;
	D3DXVECTOR3 mDirection;
};

typedef	CGrid<SEntityPickerSector, 1, 1>		TEntityPickerGrid;
extern TEntityPickerGrid EntityPickerGrid;


#endif
