// Network.cpp: implementation of the Network class.
//
//////////////////////////////////////////////////////////////////////

#include "Network.h"
#include "Commands.h"



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

Network::Network()
:connected( false),
size(0)
{  
	setTimeout(0, 0);
}

Network::~Network()
{		
}

//----------------------------------------------------------
int Network::send( char *buffer, unsigned int size )
{
	return ::send( sockfd, buffer, size, NULL);
}

//----------------------------------------------------------
void Network::receive()
{


	int recvSize = receive( receiveBuffer + size, BUFFSIZE - size);
	if( recvSize > 0)
	{
		size += recvSize;
	}
	else
	{
		if( recvSize < 0)
		{
			connected = false;
		}
	}
}

//----------------------------------------------------------
int Network::receive( char *buffer, unsigned int size)
{
	fd_set readfds;
	FD_ZERO( &readfds);
	FD_SET( sockfd, &readfds);

	
	select(sockfd+1, &readfds, NULL, NULL, &tv);

	int rsize;

	if (FD_ISSET( sockfd, &readfds))
	{
		rsize = ::recv( sockfd, buffer, size, NULL);
	}
	else
	{
		rsize = 0;
	}
	
	if( rsize < 0)
	{
		perror( "receive");
		connected = false;
	}
	else
	{
		if( rsize < 0)
		{
			connected = false;
		}
	}
	return rsize;
}

//----------------------------------------------------------
bool Network::receiveReadyAll( unsigned long& myID, unsigned long& clientCount)
{
	if( size < sizeof( myID) + sizeof( clientCount))
	{
		receive();
	}
	if( size < sizeof( myID) + sizeof( clientCount))
	{
		return false;
	}
	
	myID = *(int*)receiveBuffer;
	size -= sizeof( myID);
	memmove( receiveBuffer, receiveBuffer + sizeof( myID), size);
	
	clientCount= *(int*)receiveBuffer;
	size -= sizeof( clientCount);
	memmove( receiveBuffer, receiveBuffer + sizeof( clientCount), size);
	
	return true;
}

//----------------------------------------------------------
void Network::sendReadyAll(unsigned long myNumber, unsigned long clientCount)
{
	char buffer[ BUFFSIZE];
	unsigned long size = 0;
	
	memcpy( buffer, &myNumber, sizeof(myNumber));
	size += sizeof( myNumber);
	memcpy( buffer+size, &clientCount, sizeof(clientCount));
	size += sizeof( clientCount);

	send( buffer, size);
		
}
//----------------------------------------------------------
bool Network::receiveTick( unsigned long& tick, NetData* data, unsigned int clientCount)
{
	if( size < sizeof( tick) + clientCount * sizeof( NetData))
	{
		receive();
	}
	if( size < sizeof( tick) + clientCount * sizeof( NetData))
	{
		return false;
	}
	
	tick = *(int*)receiveBuffer;
	size -= sizeof( tick);
	memmove( receiveBuffer, receiveBuffer + sizeof( tick), size);
	
	memcpy( data, receiveBuffer, clientCount * sizeof( NetData)); 
	size -= clientCount * sizeof( NetData);
	memmove( receiveBuffer, receiveBuffer + clientCount * sizeof( NetData), size);
	
	return true;
}

//----------------------------------------------------------
void Network::sendTick( unsigned long tick, const NetData* data, unsigned int clientCount /* = 1 */)
{
	char buffer[ BUFFSIZE];
	unsigned long size = 0;
	
	memcpy( buffer+size, &tick, sizeof(tick));
	size += sizeof( tick);
	memcpy( buffer+size, data, sizeof( NetData) * clientCount);
	size += sizeof( NetData) * clientCount;

	send( buffer, size);
		
}

//----------------------------------------------------------
bool Network::connect( std::string server, int port)
{
	if ((he=gethostbyname( server.c_str())) == NULL) {  // get the host info 
		perror("gethostbyname");
		return false;
	}

	if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		perror("socket");
		return false;
	}

	their_addr.sin_family = AF_INET;    // host byte order 
	their_addr.sin_port = htons( port);  // short, network byte order 
	their_addr.sin_addr = *((struct in_addr *)he->h_addr);
	memset(&(their_addr.sin_zero), '\0', 8);  // zero the rest of the struct 

	if (::connect(sockfd, (struct sockaddr *)&their_addr,
                                              sizeof(struct sockaddr)) == -1) {
		perror("connect");
		return false;
	}
	return true;
}

//----------------------------------------------------------
int Network::accept()
{
	struct timeval tv;
	fd_set readfds;
	int sin_size;
	int new_fd;
	tv.tv_sec = 0;
	tv.tv_usec = 100;

	FD_ZERO( &readfds);
	FD_SET( sockfd, &readfds);

	// don't care about writefds and exceptfds:
	if( select( sockfd+1, &readfds, NULL, NULL, &tv) > 0)
	{
		sin_size = sizeof(struct sockaddr_in);
		if ((new_fd = ::accept(sockfd, (struct sockaddr *)&their_addr, &sin_size)) == -1) 
		{
			perror("accept");
			return -1;
		}
		else
		{
			char yes =  1;
			if (setsockopt( new_fd, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof(int)) == -1) {
				perror( "setsockopt");
				return 0;
			}

			return new_fd;
		}
	}
	else
	{
		return 0;
	}

}
//----------------------------------------------------------
bool Network::listen( int port)
{
	char yes = 1;
	
	if ((sockfd = socket( AF_INET, SOCK_STREAM, 0)) == -1) {
		perror( "socket");
		return false;
	}
	
	if (setsockopt( sockfd, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof(int)) == -1) {
		perror( "setsockopt");
		return false;
	}


	my_addr.sin_family = AF_INET;         // host byte order
	my_addr.sin_port = htons( port);     // short, network byte order
	my_addr.sin_addr.s_addr = INADDR_ANY; // automatically fill with my IP
	memset(&(my_addr.sin_zero), '\0', 8); // zero the rest of the struct

	if ( bind( sockfd, (struct sockaddr *)&my_addr, sizeof(struct sockaddr)) == -1) 
	{
		perror("bind");
		return false;
	}

	if (::listen( sockfd, SOMAXCONN) == -1) 
	{
		perror("listen");
		return false;
	}
	
	connected = true;
	return true;
}

//----------------------------------------------------------
bool Network::disconnect( )
{
	return true;
}

//----------------------------------------------------------
bool Network::init()
{
	WORD wVersionRequested;
	WSADATA wsaData;
	wVersionRequested = MAKEWORD( 2, 0 );
	return WSAStartup( wVersionRequested, &wsaData ) == 0;
}

//----------------------------------------------------------
void Network::sendReady() 
{ 	
	unsigned long status = NET_READY;
	send( (char*)&status, sizeof( status));
}

void Network::setTimeout( unsigned int sec, unsigned int usec)
{
	tv.tv_sec = sec;
	tv.tv_usec = usec;
}