// Network.h: interface for the Network class.
//
//////////////////////////////////////////////////////////////////////

#if !defined __NETWORK_H__
#define __NETWORK_H__

#include <winsock.h>
#include <string>

#include "NetData.h"
#define TIMEOUT = 1000;


class Network  
{
public:
	
	static bool init();
	
	// for client
	bool connect( std::string server, int port);
	
	// for server
	bool listen( int port);	
	int accept();

	// for both
	bool disconnect();
	

	Network( );
	virtual ~Network();

	bool isConnected() { return connected;}

	void setSocket( int socket) { sockfd = socket; }

	void sendReady();
	void sendReadyAll( unsigned long  myNumber, unsigned long clientCount);
	void sendTick( unsigned long tick, const NetData* data, unsigned int clientCount = 1);

	bool receiveReadyAll( unsigned long& myID, unsigned long& clientCount);
	bool receiveTick( unsigned long& tick, NetData* data, unsigned int clientCount);
	
	void setTimeout( unsigned int sec, unsigned int usec);

	int receive( char* buffer, unsigned int size);
	int send( char* buffer, unsigned int size);


protected:
	void receive();
		
private:
	bool connected;
	
	int sockfd;

	struct sockaddr_in my_addr;    // my address information
    struct sockaddr_in their_addr; // connector's address information
    int sin_size;

	struct hostent *he;
	struct timeval tv;

#define BUFFSIZE 1024
	char	receiveBuffer[ BUFFSIZE];
	unsigned long	size;
};

#endif // !defined __NETWORK_H__
