#pragma warning( disable:4786 )
#ifndef __ERRORS_H
#define __ERRORS_H

#include <string>
#include <stdexcept>

#define BASE_ERROR_PARAMS	__FILE__, __LINE__
#define THROW_ERROR(msg)				throw EBaseError( msg, BASE_ERROR_PARAMS )
#define THROW_DXERROR(result,msg)		throw EDXError( result, msg, BASE_ERROR_PARAMS )


class EBaseError : public std::runtime_error {
public:
	EBaseError( std::string msg, std::string fileName, int lineNumber )
	:	std::runtime_error( msg ),
		mFileName( fileName ),
		mLineNumber( lineNumber )
	{
		mWhereMsg = "file: " + mFileName;
	};

	// mimick the runtime_error style
	virtual const char* where() const {	return mWhereMsg.c_str(); }

	std::string const& getFileName() const { return mFileName; }
	int getLineNumber() const { return mLineNumber; }

private:
	std::string			mWhereMsg;
	std::string const	mFileName;
	int const			mLineNumber;
};

class EDXError : public EBaseError {
public:
	EDXError( HRESULT dxresult, std::string msg, std::string fileName, int lineNumber )
	:	EBaseError( msg, fileName, lineNumber ),
		mDXResult( dxresult )
	{
	};

	HRESULT const& getDXResult() const { return mDXResult; };

private:
	HRESULT	const	mDXResult;
};


#endif // __ERRORS_H
