/**
 *  @file engine/Picture.h
 *  Picture for the entity.
 */

#ifndef __PICTURE_H
#define __PICTURE_H

/**
 *  Picture for the entity.
 *
 *  Simply contains sprite texture coordinates (because all sprites are
 *  stuffed into one big texture). Not much interest from the game side,
 *  see CPictureBundle instead.
 *
 *  @see CPictureBundle.
 */
class CPicture {
public:
	CPicture( float x1, float y1, float x2, float y2 )
		: mX1(x1), mY1(y1), mX2(x2), mY2(y2) { }
	
	float getX1() const { return mX1; }
	float getY1() const { return mY1; }
	float getX2() const { return mX2; }
	float getY2() const { return mY2; }
	
private:
	float	mX1, mY1, mX2, mY2;
};


#endif
