
#ifndef __SPRITE_H
#define __SPRITE_H

#include <d3dx8math.h>

class CPicture;

#pragma pack(1)

struct SSpriteData {
public:
	SSpriteData( 
		D3DXVECTOR3 p = D3DXVECTOR3( 0,0,0 ),
		D3DXVECTOR3 op = D3DXVECTOR3( 0,0,0 ),
		float s = 1.0f,
		D3DCOLOR c = D3DCOLOR(0xFFffffff),
		const CPicture* pic = NULL
	) : position( p ), oldPosition( op ), size( s ), color( c ), picture( pic ) { }

public:
	D3DXVECTOR3		position;
	D3DXVECTOR3		oldPosition;
	float			size;
	D3DCOLOR		color;
	const CPicture* picture;
};

struct SSpriteInfo {
public:
	SSpriteInfo()
		: data( NULL ), index( 0 ) { }
	SSpriteInfo( SSpriteData& d, int idx )
		: data( &d ), index( idx ) { }

	SSpriteData*	data;
	int				index;
};


#pragma pack()


#endif
