#pragma warning(disable:4786)

#include "game.core.h"
#include "../engine/EntityRenderer.h"
#include "../engine/Mesh.h"
#include "../engine/Terrain.h"
#include "../engine/TerrainGen.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/resource/PictureBundle.h"

// ENGINE CONSTANTS
#include "EngineConstants.h"
#include "../utils/Random.h"

#include "../engine/TextRenderer.h"
#include <cassert>


// ------------------------------------------------------------------
//  basic stuff


//====================-----------------------------------------------
// Konstruktorius
//====================-----------------------------------------------
CGameCore::CGameCore( CConfig& config )
:	CBaseGame( config ),
	mTerrainCamera( NULL ),
	mSoldierPool( NULL ),
	mCloudPool( NULL ),
	mTeroristPool( NULL )
{
}

//====================-----------------------------------------------
// Destruktorius
//====================-----------------------------------------------
CGameCore::~CGameCore()
{
	delete mTerrainCamera;
	delete mSoldierPool;
	delete mCloudPool;
	delete mTeroristPool;
}

//====================-----------------------------------------------
// Kameros creatas
//====================-----------------------------------------------
CCamera* CGameCore::createCamera()
{
	mTerrainCamera = new CBasicCamera();
	mTerrainCamera->getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, 30.0f );

	return mTerrainCamera;
}

// ------------------------------------------------------------------
//  input


void CGameCore::onMouseLChange( bool pressed )
{
	if (pressed)
	CEntityRayPicker<TRayGrid>::putRay(
        mGrid,
        getCamera().getPosition(),
        getCamera().getWorldRay( getMouse().getMouseX(), getMouse().getMouseY() )
    );
	else
	{
		for (int i = 0; i < mGrid.getSecsCount(); i++) {
			SRaySector& s = mGrid.getSectorByIndex(i);
			s.mHasRay = false;
		}
			
	}
}

void CGameCore::onMouseRChange( bool pressed )
{
}

void CGameCore::onKeyChange( int key, bool pressed )
{
}

void CGameCore::onProcessInput()
{
	assert( mTerrainCamera );

	// update rotation from keys
	if( getKeyboard().isKeyPressed(VK_UP) )		mTerrainCamera->doPitch( 0.05f );
	if( getKeyboard().isKeyPressed(VK_DOWN) )	mTerrainCamera->doPitch( -0.05f );
	if( getKeyboard().isKeyPressed(VK_LEFT) )	mTerrainCamera->doYaw( 0.05f );
	if( getKeyboard().isKeyPressed(VK_RIGHT) )	mTerrainCamera->doYaw( -0.05f );
	if( getKeyboard().isKeyPressed('S') )		mTerrainCamera->doMove( 70.0f );
	if( getKeyboard().isKeyPressed('X') )		mTerrainCamera->doMove( -70.0f );
	if( getKeyboard().isKeyPressed('Z') )		mTerrainCamera->doStrafe( -40.0f );
	if( getKeyboard().isKeyPressed('C') )		mTerrainCamera->doStrafe( 40.0f );
	if( getKeyboard().isKeyPressed('Q') )		mTerrainCamera->doRise( 40.0f );
	if( getKeyboard().isKeyPressed('A') )		mTerrainCamera->doRise( -40.0f );
}


// ------------------------------------------------------------------
//  initialization


//====================-----------------------------------------------
// INIT
//====================-----------------------------------------------
void CGameCore::onInitialize()
{
	// Terrain
	mTerrainCamera->setTerrain( getTerrain() );
	CTerrainGen::fillTexture( getTerrain(), CResourceId("TerrainGray.png"), -50.0f, 100.0f );

	// Max entities
	int maxEntities = getEntities().getMaxEntities();
	
	// Poolai
	mSoldierPool = new TSoldierPool(maxEntities / 10);
	mCloudPool = new TCloudPool(maxEntities / 100);
	mTeroristPool = new TTeroristPool(35);

	// Paveixliukai
	CPictureBundle& pb = CPictureBundle::getInstance();
	const CPicture& pic1 = *pb.getResourceById( CResourceId("Sprite.png") );
	const CPicture& pic2 = *pb.getResourceById( CResourceId("Game_Cloud.png") );
	const CPicture& pic3 = *pb.getResourceById( CResourceId("God.png") );

	int i;

	// Entity.Soldier ikelimas
	for( i = 0; i < maxEntities / 10; ++i ) {
		CEntitySoldier& e1 = mSoldierPool->add();
		getEntities().add( e1 );
		e1.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		e1.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		e1.getOldPosition() = e1.getPosition();
		e1.mDeciderCounter = rand()&15;
//		e1.mDecider = NULL;
		e1.setPicture( pic1 );
		e1.setSize( 4.0f );
		e1.setColor( 0xFFFF0000 );
		e1.mFlags = CEntitySoldier::F_GRAVITY;
	}

	// Entity.Cloud ikelimas
	for( i = 0; i < maxEntities / 100; ++i ) {
		CEntityCloud& e2 = mCloudPool->add();
		getEntities().add( e2 );
		e2.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), random::randf(40.0f)+180.0f );
		e2.mVelocity = D3DXVECTOR3(0, 0, 0);
		e2.getOldPosition() = e2.getPosition();
		e2.mDeciderCounter = rand()&15;
//		e2.mDecider = NULL;
		e2.setPicture( pic2 );
		e2.setSize( random::randf(10.0f) + 4.0f );
		e2.setColor( 0xFFFFFFFF );
		e2.mFlags = 0;
	}

	// Entity.Terorist ikelimas
	for( i = 0; i < 35; ++i ) {
		CEntityTerorist& e3 = mTeroristPool->add();
		getEntities().add( e3 );
		e3.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		e3.mVelocity = D3DXVECTOR3( random::randfs(5.0f), random::randf(5.0f), 0.0f );
		e3.getOldPosition() = e3.getPosition();
		e3.mDeciderCounter = rand()&15;
//		e3.mDecider = NULL;
		e3.setPicture( pic3 );
		e3.setSize( 8.0f );
		e3.setColor( 0xFF8080FF );
		e3.mFlags = CEntityTerorist::F_GRAVITY + CEntityTerorist::F_TERORIST;
	}

	// Game memberiai
	mGame_Terorists = 35;
	mGame_Soldiers = 0;

	for (i = 0; i < mGrid.getSecsCount(); i++)
		mGrid.getSectorByIndex(i).mGoBoom = false;

	//static CMesh* mesh = new CMesh( 
	//	CResourceId( "Sphere.x" ),
	//	CResourceId( "TexturedMesh.sha" ),
	//	CResourceId( "Terrain.png" ) );

	//getObjects().addObject( *mesh );

}


// ------------------------------------------------------------------
//  game logic


void CGameCore::onUpdate()
{
	// Entity.Terorist updeitas
	TTeroristPool::iterator it_terorist;
	for( it_terorist = mTeroristPool->begin(); it_terorist != mTeroristPool->end();  ) {
		CEntityTerorist& e3 = *it_terorist;
		assert( e3.mDeciderCounter >= 0 );
		e3.update();
		if( e3.mFlags & CEntityCloud::F_KILLED ) {
			it_terorist = mTeroristPool->erase( it_terorist );
			getEntities().remove( e3 );
		} else {
			++it_terorist;
		}
	}

	// Entity.Soldier updeitas
	TSoldierPool::iterator it_soldier;
	for( it_soldier = mSoldierPool->begin(); it_soldier != mSoldierPool->end();  ) {
		CEntitySoldier& e1 = *it_soldier;
		assert( e1.mDeciderCounter >= 0 );
		e1.update();
		if( e1.mFlags & CEntitySoldier::F_KILLED ) {
			it_soldier = mSoldierPool->erase( it_soldier );
			getEntities().remove( e1 );
		} else {
			++it_soldier;
		}
	}



	// Atnaujinam sektoriu bombu laikus ir patikrinam ar toliau zudyt
	for (int i = 0; i < mGrid.getSecsCount(); i++)
	{
		SRaySector& s = mGrid.getSectorByIndex(i);
		if (s.mGoBoom)
			s.mBombTime++;
		if (s.mBombTime > 10) {
			s.mGoBoom = false;
			s.mBombTime = 0;
		}
	}

	// Entity.Cloud updeitas
	TCloudPool::iterator it_cloud;
	for( it_cloud = mCloudPool->begin(); it_cloud != mCloudPool->end();  ) {
		CEntityCloud& e2 = *it_cloud;
		assert( e2.mDeciderCounter >= 0 );
		e2.update();
		if( e2.mFlags & CEntityCloud::F_KILLED ) {
			it_cloud = mCloudPool->erase( it_cloud );
			getEntities().remove( e2 );
		} else {
			++it_cloud;
		}
	}

}


// ------------------------------------------------------------------
//  rendering

void CGameCore::onRenderBeforeAll()
{
}

void CGameCore::onRenderAfterWorld()
{
}

void CGameCore::onRenderAfterAll()
{
	CTextRenderer& text = getTextRenderer();
	text.renderScreenText(10, 100, "\"Terorism\" by Maverick", 0xffffffff);
	
	char buferis[200];
    
	// how much entity.terorist left?
	sprintf(buferis, "Terrorists left: %i", mGame_Terorists);
    text.renderScreenText(10, 130, buferis, 0xffffffff);

	// how much entity.soldier killed?
    sprintf(buferis, "People killed: %i", mGame_Soldiers);
    text.renderScreenText(10, 145, buferis, 0xffffffff);

}

// SHOOT TERORIST - paleidzia bomba sektoriuj
bool CGameCore::ShootTerorist(CEntity& entity)
{
	SRaySector& s = mGrid.getSectorByPosition( entity.getPosition().x, entity.getPosition().y );
	if( s.mHasRay )
		if (CEntityRayPicker<TRayGrid>::intersects( entity, s )) {
			s.mGoBoom = true;
			s.mBombTime = 0;

			mGame_Terorists--;
			return true;
		}
 
	return false;
}	 

// KILL SOLDIER - patikrint ar galima mirti ;)
bool CGameCore::KillSoldier(CEntitySoldier& entity)
{
	SRaySector& s = mGrid.getSectorByPosition( entity.getPosition().x, entity.getPosition().y );
	if ( s.mGoBoom ) {
		mGame_Soldiers++;
		return true;
	}	

	return false;	
}