/**
 *  @file game/MyGame.h
 *  Your game application code.
 */

#ifndef __MY_GAME_H
#define __MY_GAME_H

#include "entity.soldier.h"
#include "entity.cloud.h"
#include "entity.terorist.h"

#include "../engine/BaseGame.h"
#include "../utils/FixedPool.h"
#include "../utils/Singleton.h"

#include "sector.bomb.h"
#include "../engine/grid.h"

#include "../engine/TextRenderer.h"


class CBasicCamera;
//=======================-------------------------------------
// CGameCore 
//=======================-------------------------------------
class CGameCore : public CBaseGame, public CSingleton<CGameCore>
{
public:
	typedef CFixedPool<CEntitySoldier>		TSoldierPool;
	typedef CFixedPool<CEntityCloud>		TCloudPool;
	typedef CFixedPool<CEntityTerorist>		TTeroristPool;


public:
	static void init( CConfig& config ) {
		CGameCore* game = new CGameCore( config ); assert( game );
		assignInstance( *game );
	}
	virtual ~CGameCore();

protected:
	/// Receive left mouse button change.
	virtual void	onMouseLChange(bool pressed);
	/// Receive right mouse button change.
	virtual void	onMouseRChange(bool pressed);
	/// Receive key state change.
	virtual void	onKeyChange(int key, bool pressed);
	
	/**
	 *  Initialize the game.
	 */
	virtual	void onInitialize();
	
	/**
	 *  Process input.
	 *  The engine calls this method for processing input.
	 */
	virtual void onProcessInput();

	/**
	 *  Execute game logic.
	 *  The engine calls this method when game update time comes.
	 */
	virtual void onUpdate();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method before rendering anything.
	 */
	virtual void onRenderBeforeAll();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering all world
	 *  objects.
	 */
	virtual void onRenderAfterWorld();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering everything.
	 */
	virtual void onRenderAfterAll();

protected:
	virtual CCamera* createCamera();

private:
	CGameCore(CConfig& config);

	static CGameCore* createInstance() {
		assert( !"Must be initialized first" );
		return 0;
	}

	static void deleteInstance( CGameCore& instance ) {
		delete &instance;
	}

	friend CSingleton<CGameCore>;	

private:
	CBasicCamera*	mTerrainCamera;

public:
	// Metodai
	bool ShootTerorist(CEntity& entity);
	bool KillSoldier(CEntitySoldier& entity);

	// Memberiai
	bool mMouseLPressed;

	TSoldierPool*	mSoldierPool;
	TCloudPool*		mCloudPool;
	TTeroristPool*	mTeroristPool;

	TRayGrid		mGrid;

	// Game memberiai
	int	mGame_Terorists;
	int	mGame_Soldiers;
};

#endif