#pragma warning(disable:4786)
#pragma warning(disable:4355)

//#include <cassert>

#include "BaseGame.h"

#include "AppContext.h"
#include "../engine/FrameTime.h"
#include "../engine/EntityRenderer.h"
#include "../engine/Billboarder.h"
#include "../engine/TextRenderer.h"
#include "../engine/Terrain.h"
#include "../engine/TerrainGen.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/resource/PictureBundle.h"

#include "../utils/Config.h"

// ENGINE CONSTANTS
#include "../game/EngineConstants.h"


// ------------------------------------------------------------------
//  basic stuff

//// msvcprtd.lib(MSVCP60D.dll)
//// error LNK2005


CBaseGame::CBaseGame( CConfig& config )
:	mConfig( config ),
	mAppContext( NULL ),
	mKeyboard( NULL ),
	mMouse( NULL ),
	mKeyboardListener( *this ),
	mMouseListener( *this ),
	mCamera( NULL ),
	mEntities( NULL ),
	mTerrain( NULL ),
	mBillboarder( NULL ),
	mTextRenderer( NULL ),
	mTimeSinceLastActualUpdate( 0 ),

	mHackFrameTimeForAnimation( 0, 0, 0, 0 )
{

}

CBaseGame::~CBaseGame()
{
	delete mCamera;
	delete mEntities;
	delete mTerrain;
	delete mBillboarder;
	delete mTextRenderer;
}

void CBaseGame::setAppContext( CAppContext const& appContext )
{
	mAppContext = &appContext;
}

void CBaseGame::setKeyboard( CKeyboard& keyboard )
{
	keyboard.setListener( &mKeyboardListener );
	mKeyboard = &keyboard;
}

void CBaseGame::setMouse( CMouse& mouse )
{
	mouse.setListener( &mMouseListener );
	mMouse = &mouse;
}

// ------------------------------------------------------------------
//  CDXObjectContainer
HRESULT CBaseGame::onCreateDevice( IDirect3DDevice8* device )
{
	CDXObject::onCreateDevice( device );
	static bool once = true;
	if( once ) {
		// game init
		initialize();
		once = true;
	}
	return mObjects.onCreateDevice( device );
}

HRESULT CBaseGame::onResetDevice()
{
	assert( mAppContext );

	CDXObject::onResetDevice();
	// camera
	getCamera().setProjectionParams(
		3.1415927f * 0.4f,
		mAppContext->getWindowAspect(),
		10.0f,
		8200.0f
	);
	getCamera().setDeviceTransforms( getDevice(), false, true );

	return mObjects.onResetDevice();
}

HRESULT CBaseGame::onLostDevice()
{
	CDXObject::onLostDevice();
	return mObjects.onLostDevice();
}

HRESULT CBaseGame::onDestroyDevice()
{
	CDXObject::onLostDevice();
	return mObjects.onDestroyDevice();
}

void CBaseGame::render( CFrameTime const& frameTime )
{
	mHackFrameTimeForAnimation = frameTime;

	assert( mAppContext );
	getDevice().Clear( 
		0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER, 
		0x00000000, 1.0f, 0 );

	CCamera& cam = getCamera();
	cam.setProjectionParams(
		cam.getFOV(),
		mAppContext->getWindowAspect(),
		cam.getZNear(),
		cam.getZFar()
	);
	cam.setDeviceTransforms( getDevice(), true, true );

	// game: before
	onRenderBeforeAll( frameTime );

	// render
	mObjects.render( frameTime );

	// game: after
	onRenderAfterAll( frameTime );

	getTextRenderer().renderScreenText( 4, 2, mAppContext->getFPS(), 0x80ffff00 );
}

void CBaseGame::update( CFrameTime const& frameTime )
{
	mHackFrameTimeForAnimation = frameTime;

	onProcessInput();

	getCamera().update( frameTime );

	float t = frameTime.getDelta() + mTimeSinceLastActualUpdate;
	while( t >= gcon::UPDATE_DT )
	{
		onUpdate();
		t -= gcon::UPDATE_DT;

		mTimeSinceLastActualUpdate = 0;
	}

	mTimeSinceLastActualUpdate = t;
	mAlpha = mTimeSinceLastActualUpdate * gcon::UPDATE_FREQ;

}

/*	int maxEntities = cfg.readI( "game", "maxEntities", 10000 );
	engine.setEntities( *new CEntityRenderer( maxEntities ) );
	mObjects.addObject( engine.getEntities() );

	float terrTexX = cfg.readF( "game", "terrainTexTilesX", 4.0 );
	float terrTexY = cfg.readF( "game", "terrainTexTilesY", 4.0 );
	std::string terrTex = cfg.readS( "game", "terrainTex", "Terrain.png" );
	engine.setTerrain( *new CTerrain( CResourceId("Terrain.sha"), CResourceId(terrTex), terrTexX, terrTexY ) );
	mObjects.addObject( engine.getTerrain() );
	CTerrainGen::fillConst( engine.getTerrain(), 0.0f );

	engine.setBillboarder( *new CBillboarder() );
	mObjects.addObject( engine.getBillboarder() );

	std::string fontName = cfg.readS( "screen", "fontName", "Arial" );
	int fontSize = cfg.readI( "screen", "fontSize", 9 );
	bool fontBold = cfg.readI( "screen", "fontBold", 1 ) ? true : false;
	bool fontItalic = cfg.readI( "screen", "fontItalic", 0 ) ? true : false;
	engine.setTextRenderer( *new CTextRenderer( fontName.c_str(), fontSize, fontBold, fontItalic ) );
	mObjects.addObject( engine.getTextRenderer() );*/

void CBaseGame::initialize()
{
	mCamera = createCamera();
	assert( mCamera );
	
	mEntities = createEntityRenderer();
	assert( mEntities );
	mObjects.addObject( *mEntities );

	mTerrain = createTerrain();
	assert( mTerrain );
	mObjects.addObject( *mTerrain );

	mBillboarder = createBillboarder();
	assert( mBillboarder );
	mObjects.addObject( *mBillboarder );

	mTextRenderer = createTextRenderer();
	assert( mTextRenderer );
	mObjects.addObject( *mTextRenderer );

	onInitialize();
}

CTerrain* CBaseGame::createTerrain()
{
	float terrainTextureX = mConfig.readF( "game", "terrainTexTilesX", 4.0 );
	float terrainTextureY = mConfig.readF( "game", "terrainTexTilesY", 4.0 );
	std::string terrainTextureName = mConfig.readS( "game", "terrainTex", "Terrain.png" );

	CTerrain* terrain = new CTerrain( 
		CResourceId( "Terrain.sha" ),
		CResourceId( terrainTextureName ),
		terrainTextureX, terrainTextureY );

	CTerrainGen::fillConst( *terrain, 0.0f );

	return terrain;
}

CCamera* CBaseGame::createCamera()
{
	CCamera* camera = new CCamera();
	camera->getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, 100.0f );

	return camera;
}

CEntityRenderer* CBaseGame::createEntityRenderer()
{
	assert( mCamera );
	int maxEntities = mConfig.readI( "game", "maxEntities", 10000 );

	return new CEntityRenderer( maxEntities, *mCamera, mAlpha );
}

CBillboarder* CBaseGame::createBillboarder()
{
	assert( mCamera );
	return new CBillboarder( *mCamera, mAlpha );
}

CTextRenderer* CBaseGame::createTextRenderer()
{
	std::string fontName = mConfig.readS( "screen", "fontName", "Arial" );
	int fontSize = mConfig.readI( "screen", "fontSize", 9 );
	bool fontBold = mConfig.readI( "screen", "fontBold", 1 ) ? true : false;
	bool fontItalic = mConfig.readI( "screen", "fontItalic", 0 ) ? true : false;

	return new CTextRenderer( fontName.c_str(), fontSize, fontBold, fontItalic );

//	return NULL;
}



// ------------------------------------------------------------------
//  input


void CBaseGame::onMouseLChange( bool pressed )
{
}

void CBaseGame::onMouseRChange( bool pressed )
{
}

void CBaseGame::onKeyChange( int key, bool pressed )
{
}

void CBaseGame::onProcessInput()
{
}


// ------------------------------------------------------------------
//  initialization


void CBaseGame::onInitialize()
{
}


// ------------------------------------------------------------------
//  game logic


void CBaseGame::onUpdate()
{
}


// ------------------------------------------------------------------
//  rendering

void CBaseGame::onRenderBeforeAll( CFrameTime const& ft )
{
}

void CBaseGame::onRenderAfterWorld( CFrameTime const& ft )
{
}

void CBaseGame::onRenderAfterAll( CFrameTime const& ft )
{
}