#ifndef __GAME_APP_H
#define __GAME_APP_H

#include "../dxutils/D3DApp.h"
#include "AppContext.h"
#include "FrameTime.h"
#include "input/Keyboard.h"
#include "input/Mouse.h"


class CConfig;
class CBaseGame;
class CGameApp : public CD3DApplication {
public:
    CGameApp( CBaseGame& game, CConfig& config );
	~CGameApp();
	
    virtual HRESULT OneTimeSceneInit();
    virtual HRESULT InitDeviceObjects();
    virtual HRESULT RestoreDeviceObjects();
    virtual HRESULT InvalidateDeviceObjects();
    virtual HRESULT DeleteDeviceObjects();
    virtual HRESULT FrameMove();
    virtual HRESULT Render();
	
    virtual LRESULT MsgProc( HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam );

private:
	CBaseGame&	mGame;
	CConfig&	mConfig;

	CKeyboard	mKeyboard;
	CMouse		mMouse;

	CAppContext	mAppContext;

	CFrameTime	mFrameTime;
//	float		mLastUpdateTime;
};

#endif
