/**
 *  @file engine/TextRenderer.h
 *  Text rendering.
 */

#ifndef __TEXT_RENDERER_H
#define __TEXT_RENDERER_H


#include "DXObject.h"
//#include <string>

class CD3DFont;


/**
 *  Utility to render text.
 *
 *  To access the text renderer use CEngine.
 *  @see CEngine.
 */
class CTextRenderer : public CDXObject {
public:
	CTextRenderer( const std::string& fontName, int fontSize, bool bold = true, bool italic = false );
	virtual ~CTextRenderer();
	
	virtual HRESULT onCreateDevice( IDirect3DDevice8* device );
	virtual HRESULT onLostDevice();
	virtual HRESULT onResetDevice();
	virtual HRESULT onDestroyDevice();

	/**
	 *  Renders text.
	 *  @param x Left X coordinate in pixels.
	 *  @param y Top Y coordinate in pixels.
	 *  @param text Text (supports '\n' characters).
	 *  @param color The color.
	 */
	void renderScreenText( int x, int y, const std::string& text, DWORD color = 0xFFFFFFFF );

private:
	CD3DFont*	mFont;
};



#endif
