#ifndef __ANIMATION_SET_H
#define __ANIMATION_SET_H

#include <vector>
#include "../Picture.h"


class CFrameTime;

class CAnimationSet
{
	typedef std::vector<CPicture const*>	TPictureList;
public:
	CAnimationSet();

	CPicture const& getPicture( float startTime, float animationSpeed ) const;

	void add( CPicture const& pic );
	void update( CFrameTime const& frameTime );

private:
	TPictureList	mPictures;
	float			mCurrentTime;
};

template<typename _T>
class CAnimationIdSet
{
	typedef _T						value_type;
	typedef std::vector<value_type>	TList;
public:
	value_type const& getValue( float startTime, float animationSpeed ) const
	{
		return	mList[ ((int)( ( mCurrentTime - startTime ) * animationSpeed )) % mList.size() ];
	}

	void add( value_type const& v ) {
		mList.push_back( v );
	}

	void update( CFrameTime const& frameTime ) {
		mCurrentTime = frameTime.getTime();
	}

private:
	TList	mList;
	float	mCurrentTime;
};

#endif