#ifndef __ANIMATOR_H
#define __ANIMATOR_H

#include <cassert>
#include "AnimationSet.h"
#include "../FrameTime.h"


class CPicture;

template <float SPEED = 1.0f>
class CAnimator
{
public:
	CAnimator() : mAnimationSet( NULL ) {}

	void init( CAnimationSet const& animationSet, CFrameTime const& frameTime ) {
		mAnimationSet = &animationSet;
		reset( frameTime );
	}

	CPicture const& getPicture() const {
		assert( mAnimationSet );
		return mAnimationSet->getPicture( mStartTime, SPEED );
	}

	void reset( CFrameTime const& frameTime ) {
		mStartTime = frameTime.getTime();
	}

private:
	CAnimationSet const*	mAnimationSet;
	float					mStartTime;
};

#endif