#ifndef __KEYBOARD_H
#define __KEYBOARD_H

#include "MsgProc.h"


struct IKeyboardListener;
class CKeyboard : public IMsgProc
{
	enum { KEY_COUNT = 256 };

public:
	CKeyboard();

	virtual void onMsgProc( HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
	void setListener( IKeyboardListener* listener ) const { mListener = listener; }

	/**
	 *  Returns status of keyboard key.
	 *  @param key ASCII code or Windows virtual keycode (VK_???).
	 */
	bool isKeyPressed( int key ) const;

private:
	bool						mKeys[KEY_COUNT];

	mutable IKeyboardListener*	mListener;
};

struct IKeyboardListener
{
	virtual ~IKeyboardListener() = 0 {};

	virtual void onKeyChange( int key, bool pressed ) = 0;
};

#endif