#include "Mouse.h"

CMouse::CMouse()
:	mWidth( 1.0f ),
	mHeight( 1.0f ),
	mMouseX( 0.0f ),
	mMouseY( 0.0f ),
	mMouseLPressed( false ),
	mMouseRPressed( false ),
	mListener( NULL )
{
}

void CMouse::onMsgProc( HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
	switch( uMsg )
	{
	case WM_LBUTTONDOWN:
		if( !mMouseLPressed && mListener )
			mListener->onMouseLChange( true );
		mMouseLPressed = true;
		break;
	case WM_LBUTTONUP:
		if( mMouseLPressed && mListener  )
			mListener->onMouseLChange( false );
		mMouseLPressed = false;
		break;
	case WM_RBUTTONDOWN:
		if( !mMouseRPressed && mListener )
			mListener->onMouseRChange( true );
		mMouseRPressed = true;
		break;
	case WM_RBUTTONUP:
		if( mMouseRPressed && mListener )
			mListener->onMouseRChange( false );
		mMouseRPressed = false;
		break;
	case WM_MOUSEMOVE:
		float mx = ((float)LOWORD(lParam) / mWidth) * 2.0f - 1.0f; 
		float my = ((float)HIWORD(lParam) / mHeight) * 2.0f - 1.0f; 
		mMouseX = mx;
		mMouseY = my;
		// check buttons also - we may have missed the events if mouse was outside window
		bool btnL = (wParam & MK_LBUTTON) ? true : false;
		bool btnR = (wParam & MK_RBUTTON) ? true : false;
		if( btnL != mMouseLPressed && mListener )
			mListener->onMouseLChange( btnL );
		if( btnR != mMouseRPressed && mListener )
			mListener->onMouseRChange( btnR );
		mMouseLPressed = btnL;
		mMouseRPressed = btnR;
		break;
	};
}
