/**
 *  @file engine/resource/EffectBundle.h
 *  D3DX effect bundle.
 */
#ifndef __EFFECT_BUNDLE_H
#define __EFFECT_BUNDLE_H

#include "BundleSingleton.h"
#include "StorageResourceBundle.h"


/**
 *  D3DX effect bundle.
 *  Effect loading and shared access happens here. It's a singleton via
 *  static getInstance() method.
 *  @see CResourceId, IResourceBundle#getResourceById, IResourceBundle#rejectResource, IResourceBundle#clear.
 */
class CEffectBundle : public CStorageResourceBundle<ID3DXEffect>, public CBundleSingleton<CEffectBundle>
{
public:
	static void init( IDirect3DDevice8& device, std::string predir = "" ) {
		CEffectBundle* bundle = new CEffectBundle( device, predir );
		assert( bundle );
		assignInstance( *bundle );
	}
	
protected:
	virtual ID3DXEffect* loadResourceById( CResourceId const& id );
	virtual void touchResource( ID3DXEffect& resource );
	virtual void clearResource( ID3DXEffect& resource );
	
private:
	CEffectBundle( IDirect3DDevice8& device, const std::string& predir = "" );
	virtual ~CEffectBundle();
	friend CBundleSingleton<CEffectBundle>;
	
private:
	const std::string	mPreDir;
	IDirect3DDevice8&	mDevice;
};

#endif
