#include <d3dx8.h>
#include "myentity.h"
#include "Deciders.h"
#include "mygame.h"
#include "../utils/random.h"

#include "../engine/resource/PictureBundle.h"

static const float SUCK_SPEED = 30.0f; 

void CSuckDecider::decideFor( CMyEntity& e ) const
{
	// if ufo is affecting this sector, suck entity
	D3DXVECTOR3 const& pos = e.getPosition();

	// check if UFO was hit and for need to walk again
	if( e.mFlags&(CMyEntity::F_SUCKING|CMyEntity::F_CAPTURED) && e.mUfo->needRelease() )
	{
		e.mFlags &= ~(CMyEntity::F_SUCKING|CMyEntity::F_CAPTURED);
		e.mVelocity = CMyEntity::genWalkVelocity();
		e.mUfo = NULL;
	}

	// take a human
	if( !(e.mFlags&CMyEntity::F_CAPTURED) )
	{
		SGodzillaUfoSector& sector = CMyGame::getInstance().mGrid.getSectorByPosition( pos.x, pos.y );

		if( (sector.mGodzillaFactor>0) && !(e.mFlags&CMyEntity::F_SUCKING) )
		{
			e.mFlags &= ~CMyEntity::F_GRAVITY;
			e.mFlags |= CMyEntity::F_TOHELL;
			sector.mGodzillaFactor--;

			// change sprite and velocity
			e.setColor( 0x80e0e0e0 );
			e.setPicture( *CPictureBundle::getInstance().getResourceById(CResourceId("soul.png")) );
			e.mVelocity = D3DXVECTOR3(0,0,0.7f);

			// fade out start
			return;
		}

		if( e.mFlags&CMyEntity::F_SUCKING )
		{
			/*
			if( !sector.mUfo )
			{
				e.mFlags &= ~(CMyEntity::F_SUCKING|CMyEntity::F_CAPTURED);
				e.mVelocity = CMyEntity::genWalkVelocity();
				e.mUfo = NULL;
			}*/

			if( e.getPosition().z >= e.mUfo->getPosition().z - CUfo::UFO_RADIUS )
			{
				e.mVelocity = D3DXVECTOR3(0,0,0);
				e.mFlags &= ~CMyEntity::F_SUCKING;
				e.mFlags |= CMyEntity::F_CAPTURED;

				e.mUfo->increaseSucked();
				e.setColor( 0xe0e0e0e0 );
			}
		}

		// if there is an ufo and no sucking in progress nor captured
		if( sector.mUfo && sector.mUfo->state() == CUfo::S_SUCKING && !(e.mFlags&(CMyEntity::F_SUCKING|CMyEntity::F_CAPTURED)) && sector.mUfoFactor>0 )
		{
			sector.mUfoFactor--;

			e.mFlags |= CMyEntity::F_SUCKING;
			e.mUfo = sector.mUfo;

			// should varry
			e.mVelocity.x = 0;
			e.mVelocity.y = 0;
			e.mVelocity.z = SUCK_SPEED/2 + SUCK_SPEED*random::randf(0.5f);
		}
	}
}
