#ifndef _GODZILLA_H_
#define _GODZILLA_H_

#include <vector>
#include <d3dx8.h>

#include "GridSector.h"
#include "../engine/animator/AnimationSet.h"

class CMesh;

class CGodzilla
{
public:

	enum { HEIGHT = 80, KILL_FACTOR = 50 };

	CGodzilla();

	static D3DXVECTOR3 genDirection();

	void animation( CFrameTime const& ft ); 
	void movement( CFrameTime const& ft );
	void update();
	void reset( CFrameTime const& ft );

	D3DXVECTOR3& getOldPosition() { return mPosition; }

	D3DXVECTOR3 const& position( D3DXVECTOR3 const& pos ) { mPosition = pos; return mPosition; }
	D3DXVECTOR3 const& position() { return mPosition; }

	void scale( float s ) { mScale = s; }
	float scale() const { return mScale; }

	void speed( float s ) { mSpeed = s; }
	float speed() { return mSpeed; }

	void flying( bool f ) { mFlying = f; }
	bool flying() const { return mFlying; }

private:
	float					mLastDirChange;
	float					mScale;
	bool					mFlying;
	D3DXVECTOR3				mPosition;
	D3DXVECTOR3				mOldPosition;
	D3DXVECTOR3				mDirection;
	float					mStartTime;
	float					mSpeed;
	CMesh*					mCurrentMesh;
	CAnimationIdSet<CMesh*>	mAnimator;
};


class CGodzillaManger
{
public:
	typedef std::vector<CGodzilla*>	TGodzillaContainer;

	CGodzillaManger();

	void add( CGodzilla& godz ) {
		mGodzillas.push_back(&godz);
	}

	void update( CFrameTime const& ft );
	void put( TGrid& grid, CGodzilla& godz );

private:
	TGodzillaContainer		mGodzillas;
};

#endif // _GODZILLA_H_
