#include "MyEntity.h"

#include "Decider.h"
#include "MyGame.h"
#include "../engine/Terrain.h"
#include "../utils/random.h"

static D3DXVECTOR3 const LOWER_DUDES = D3DXVECTOR3( 0,0,-CUfo::UFO_RADIUS );

// ENGINE CONSTANTS
#include "EngineConstants.h"

void CMyEntity::init()
{
//	mAnimator.init( 
//		CMyGame::getInstance().getAnimationSet(),
//		CMyGame::getInstance().getHackFrameTimeForAnimation() );

	mUfo = NULL;
	mVelocity = D3DXVECTOR3(0,0,0);
	mFlags = 0;
	mDeciderCounter = 0;
	mDecider = NULL;
	mExists = 30;
}

D3DXVECTOR3 CMyEntity::genWalkVelocity()
{
	return D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
}

void CMyEntity::update()
{
	getOldPosition() = getPosition();

	if( mDecider ) {
		if( !mDeciderCounter ) {
			mDeciderCounter = DEFAULT_DECIDER_COUNTER;
			mDecider->decideFor( *this );
		}
	}
	--mDeciderCounter;

	D3DXVECTOR3 pos = getPosition() + mVelocity;

	if( mFlags&F_TOHELL ) {
		if( !mExists-- ) {
			mFlags |= F_KILLED;
		}
	}

	if( mFlags&F_CAPTURED )
	{
		pos = mUfo->getPosition() + LOWER_DUDES + random::randv3s( CUfo::UFO_RADIUS );

		// if ufo's at home, remove entitys
		if( mUfo->state() == CUfo::S_MAKING_GODZILLA && mUfo->needTransform()>0 )
		{
			mUfo->transform();
			mFlags |= F_KILLED;
		}
	}
	else
	{
		if( !(mFlags&F_SUCKING) )
		{
			// terrain bounds
			if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
				mVelocity.x = -mVelocity.x;
				pos.x = getOldPosition().x;
			}
			if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
				mVelocity.y = -mVelocity.y;
				pos.y = getOldPosition().y;
			}

			// terrain height
			float h = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();
			if( pos.z < h ) {
				pos.z = h;
				mVelocity.z = 0.0f; // TODO: bounce off?
			}

			if( mFlags&F_GRAVITY )
			{
				mVelocity.z -= gcon::GRAVITY;
			}
		}
		else
		{
			// sucking. cannot do anything (maybe random color?)
		}
	}

	/*
	D3DXVECTOR3 pos = getPosition() + mVelocity;

	if( !(mFlags&F_CAPTURED) )
	{
		if( mUfo && mUfo->isDead() )
		{
			// ufo's dead
			mFlags &= ~F_CAPTURED;
			mFlags |= F_GRAVITY;
			mVelocity = CMyEntity::genWalkVelocity();
		}

		// terrain bounds
		if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
			mVelocity.x = -mVelocity.x;
			pos.x = getOldPosition().x;
		}
		if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
			mVelocity.y = -mVelocity.y;
			pos.y = getOldPosition().y;
		}

		// terrain height
		float h = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();
		if( pos.z < h ) {
			pos.z = h;
			mVelocity.z = 0.0f; // TODO: bounce off?
		}

	}

	if( mFlags&F_CAPTURED )
	{
		// release entity if ufo's dead
		if( !mUfo->isDead() )
			mFlags &= ~F_CAPTURED;
		else
			getPosition() = mUfo->getPosition() + random::randv3s( CUfo::UFO_RADIUS );
	}

	if( mFlags & F_GRAVITY ) {
		mVelocity.z -= gcon::GRAVITY;
	}*/

	getPosition() = pos;
}
