/**
 *  @file game/MyEntity.h
 *  Your game entity.
 */

#ifndef __GAME_ENTITY_H
#define __GAME_ENTITY_H

#include <d3dx8math.h>

#include "../engine/Entity.h"
#include "../engine/animator/Animator.h"

class IDecider;
class CUfo;

#pragma pack(1)


/**
 *  Your game entity.
 */
class CMyEntity : public CEntity {
public:
	enum {
		F_NOTHING = 0,
		F_SUCKING = 1,
		F_CAPTURED = 2,
		F_KILLED = 4,
		F_GRAVITY = 8,
		F_TRANSFORMED = 16,
		F_TOHELL = 32,
		F_OK
	};
	enum {
		TOTAL_SUCK = 100,
		MIN_SUCK = 0,
	};
	enum { DEFAULT_DECIDER_COUNTER = 1 };

public:
	void	init();
	void	update();

	static D3DXVECTOR3 genWalkVelocity();
	
public:
	short		mExists;
	D3DXVECTOR3	mVelocity;
	short		mFlags;
	short		mDeciderCounter;
	IDecider*	mDecider;
	CUfo*		mUfo;

//	CAnimator<2.0f>	mAnimator;
};

#pragma pack()

#endif
