/**
 *  @file game/MyGame.h
 *  Your game application code.
 */

#ifndef __MY_GAME_H
#define __MY_GAME_H

#include "MyEntity.h"
#include "../engine/BaseGame.h"
#include "../utils/FixedPool.h"
#include "../utils/Singleton.h"
#include "../engine/Grid.h"
#include "../engine/Mesh.h"

#include "../engine/animator/AnimationSet.h"

#include "UfoManager.h"
#include "GodzillaManager.h"

class CBasicCamera;
/**
 *  Your game application class.
 */
class CMyGame : public CBaseGame, public CSingleton<CMyGame>
{
public:

public:
	typedef CFixedPool<CMyEntity>	TPool;
	typedef ::TGrid					TGrid;

	enum eState { PRESS, GAME, GAMEOVER, WON };
	enum { GAME_LENGTH = 2*60+3 };

public:
	static void init( CConfig& config ) {
		CMyGame* game = new CMyGame( config ); assert( game );
		assignInstance( *game );
	}
	virtual ~CMyGame();

	CAnimationSet const& getAnimationSet() { return mAnimationSet; }

protected:
	/// Receive left mouse button change.
	virtual void	onMouseLChange( bool pressed );
	/// Receive right mouse button change.
	virtual void	onMouseRChange( bool pressed );
	/// Receive key state change.
	virtual void	onKeyChange( int key, bool pressed );
	
	/**
	 *  Initialize the game.
	 */
	virtual	void onInitialize();
	
	/**
	 *  Process input.
	 *  The engine calls this method for processing input.
	 */
	virtual void onProcessInput();

	/**
	 *  Execute game logic.
	 *  The engine calls this method when game update time comes.
	 */
	virtual void onUpdate();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method before rendering anything.
	 */
	virtual void onRenderBeforeAll( CFrameTime const& ft );

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering all world
	 *  objects.
	 */
	virtual void onRenderAfterWorld( CFrameTime const& ft );

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering everything.
	 */
	virtual void onRenderAfterAll( CFrameTime const& ft );


protected:
	virtual CCamera* createCamera();

private:
	CMyGame( CConfig& config );

	static CMyGame* createInstance() {
		assert( !"Must be initialized first" );
		return 0;
	}

	static void deleteInstance( CMyGame& instance ) {
		delete &instance;
	}

	friend CSingleton<CMyGame>;	

private:
	CBasicCamera*	mTerrainCamera;
	IDecider*		mSuckDecider;
	IDecider*		mDieDecider;

	CAnimationSet	mAnimationSet;
	int				mKilled;
	int				mTotalAtStart;
	int				mCanKill;
	eState			mState;
	D3DXVECTOR3		mShotDir;
	bool			mHaveShot;
	bool			mNoShot;

	float			mStartTime;
	float			mDragStartX, mDragStartY;
	bool			mDraging;

public:
	TPool*			mPool;
	TGrid			mGrid;
	CUfoManager		mUfoManager;
	CGodzillaManger	mGodzillaManager;
};

#endif