#ifndef UFO_MANAGER_H_
#define UFO_MANAGER_H_

#include <vector>
#include <d3dx8.h>

#include "GridSector.h"
#include "../engine/resource/ResourceId.h"

class CMesh;
class CFrameTime;
class CGodzilla;

class CUfo
{
public:
	enum
	{
		MIN_Z = 200,
//		SUCK_COUNT = 200,
		MIN_AWAY_DIST = 1500,
		RAND_AWAY_DIST = 800,
		FROM_TERRAIN_CENTER_MAX = gcon::WORLD_X/2 - 100,

		GODZILLA_MAKING_TIME = 5,

		UFO_RADIUS = 35,
//		HIT_DAMAGE = 35,
		GRAVE_TIME = 5,

		INITIAL_ENERGY = 100
	};

	enum eState
	{
		S_RESTING = 0,
		S_FLYING_TO_SUCK,
		S_SUCKING,
		S_GOING_HOME,
		S_MAKING_GODZILLA,
		S_BRINGING_GODZILLA,
		S_DYING,
		S_DEAD
	};
		
	static D3DXVECTOR3 genTerrainPoint();
	static D3DXVECTOR3 genAwayPoint();
	static int SUCK_COUNT;
	static int HIT_DAMAGE;

	CUfo( D3DXVECTOR3 const& pos, CMesh& mesh );

	void attachGodzilla( CGodzilla& gdz ) { mGodzilla = &gdz; }
	CGodzilla* godzilla() { return mGodzilla; }
	void dropGodzilla();

	void update();
	void movement( CFrameTime const& ft );

	void scale( float s ) { mScale = s; }

	void flyTo( CFrameTime const& ft, D3DXVECTOR3 const& dest );
	void dropTo( CFrameTime const& ft, D3DXVECTOR3 const& dest );
	bool wasHit( D3DXVECTOR3 const& origin, D3DXVECTOR3 const& dir );

	D3DXVECTOR3& getPosition() { return mPosition; }
	D3DXVECTOR3 const& getPosition() const { return mPosition; }

	eState state() const { return mState; }
	void state( eState st ) { mState = st; }

//	bool isGone() const { return mGone; }
//	void setGone( bool gone = true ) { mGone = true; }

	int getEnergy() const { return mEnergy; }
	void damage( int dmg ) { mEnergy -= dmg; }
	bool isDead() const { return mEnergy <= 0; }

	void speed( float s ) { mSpeed = s; }
	float speed() const { return mSpeed; }

	void increaseSucked() { ++mSucked; }
	void sucked( int n ) { mSucked = n; }
	int sucked() const { return mSucked; }
	bool needRelease() const { return mNeedRelease; }
	void needRelease( bool rel ) { mNeedRelease = rel; }

	int needTransform() const { return mNeedTransform; }
	void transform() { mNeedTransform--; assert(mNeedTransform>=0); }

	D3DXVECTOR3	mSuckPoint;
	D3DXVECTOR3 mHomePoint;
	D3DXVECTOR3 mGodzillaPoint;
	float		mGraveStartTime;
	D3DXVECTOR3 mGravePoint;

private:
	D3DXVECTOR3 mPosition;
	CGodzilla*	mGodzilla;
	CMesh*		mMesh;
	eState		mState;

	float		mSpeed;
	float		mScale;
	int			mEnergy;
	int			mSucked;
	int			mNeedTransform;
	bool		mGodzillaMade;
	bool		mNeedRelease;
	float		mGodzillaMakingStart;
};

class CUfoManager
{
public:
	typedef std::vector<CUfo*>	TUfoContainer;
	struct SHitInfo
	{
		SHitInfo( float _time, D3DXVECTOR3 const& _pos, CResourceId const& tid )
			:	time(_time), pos(_pos), tex(tid) {}
		float time;
		D3DXVECTOR3 pos;
		CResourceId tex;
	};
	typedef std::vector<SHitInfo> THitContainer;

	enum
	{
		UFO_SUCK_SIDE_SIZE_HALF = 2,
		UFO_SUCK_SIDE_SIZE = UFO_SUCK_SIDE_SIZE_HALF*2 + 1
	};

	THitContainer& hits() { return mHits; }
	
	void update( CFrameTime const& ft );
	void putUfoSuck( TGrid& grid, CUfo& ufo, int cx, int cy );

	void shoot( CFrameTime const& ft, D3DXVECTOR3 const& origin, D3DXVECTOR3 const& dir );
	void hitUfo( CFrameTime const& ft, CUfo& ufo );

	TUfoContainer	mUfos;
	THitContainer	mHits;
};

#endif // UFO_MANAGER_H_
