/**
 *  @file utils/Random.h
 *  Random helpers.
 */
#ifndef __RANDOM_H
#define __RANDOM_H

#include <cstdlib>
#include <cmath>
#include <d3dx8math.h>

/// Random helpers.
namespace random {

	/// Returns float random [0..limit).
	inline float randf( float limit ) {
		return rand() / (float)(RAND_MAX+1) * limit;
	}
	/// Returns float random (-limit..limit).
	inline float randfs( float limit ) {
		return (rand()-RAND_MAX/2) / (float)((RAND_MAX+1)/2) * limit;
	}
	
	/// Returns random vector [0..limit).
	inline D3DXVECTOR3 randv3( float limit ) {
		return D3DXVECTOR3( randf(limit), randf(limit), randf(limit) );
	}
	/// Returns random vector (-limit..limit).
	inline D3DXVECTOR3 randv3s( float limit ) {
		return D3DXVECTOR3( randfs(limit), randfs(limit), randfs(limit) );
	}
};

#endif
