// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "Collidable.h"

using namespace dingus;

void CCollidable::setRotation( const SMatrix4x4& rot )
{
	dMatrix3 tr;
	tr[0] = rot._11;	tr[4] = rot._12;	tr[8] = rot._13;
	tr[1] = rot._21;	tr[5] = rot._22;	tr[9] = rot._23;
	tr[2] = rot._31;	tr[6] = rot._32;	tr[10] = rot._33;
	tr[3] = 0;			tr[7] = 0;			tr[11] = 0;
	dGeomSetRotation( mID, tr );
}

void CCollidable::getRotation( SMatrix4x4& dest ) const
{
	const dReal *m = dGeomGetRotation( mID );
	dest._11 = (float)m[0];	dest._12 = (float)m[4];	dest._13 = (float)m[ 8]; dest._14 = 0;
	dest._21 = (float)m[1];	dest._22 = (float)m[5];	dest._23 = (float)m[ 9]; dest._24 = 0;
	dest._31 = (float)m[2];	dest._32 = (float)m[6];	dest._33 = (float)m[10]; dest._34 = 0;
	dest._41 = 0;		dest._42 = 0;		dest._43 = 0;		dest._44 = 1;
}



void CCollidableMesh::initMesh( CCollidableContainer::TContainerID parent, const CCollisionMesh& mesh, bool flipCull )
{
	mMesh = &mesh;
	assert( mMesh );
	assert( mMesh->getTriListData() );
	
	mID = dCreateTriList( parent, /*NULL, NULL, NULL,*/ mesh.getTriListData(), flipCull );
}

void CCollidableRay::getParams( SVector3& pos, SVector3& dir ) const
{
	dVector3 p, d;
	dGeomRayGet(mID,p,d);
	pos.x = (float)p[0];
	pos.y = (float)p[1];
	pos.z = (float)p[2];
	dir.x = (float)d[0];
	dir.y = (float)d[1];
	dir.z = (float)d[2];
}

