// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __COLLISION_CONTEXT_H
#define __COLLISION_CONTEXT_H

#include "Collidable.h"
#include "CollisionListener.h"

namespace dingus {


// --------------------------------------------------------------------------

class CCollisionContext {
public:
	CCollisionContext();
	~CCollisionContext();

	void	addCollidable( CCollidable& c );
	void	removeCollidable( CCollidable& c );
	bool	containsCollidable( CCollidable const& c ) const;

	void	setGlobalColListener( ICollisionListener* l ) { mGlobalColListener = l; }

	void	perform();

private:
	/*
	struct SCollidePair {
		SCollidePair( dGeomID g1, dGeomID g2 ) {
			assert( g1 != g2 );
			if( g1 < g2 )
				geom1 = g1, geom2 = g2;
			else
				geom1 = g2, geom2 = g1;
		}
		dGeomID geom1, geom2;
		bool operator<( const SCollidePair& r ) const { return geom1<r.geom1 || geom1==r.geom1 && geom2<r.geom2; }
	};
	typedef std::set<SCollidePair>	TCollidePairSet;
	*/

private:
	static	void	collisionCallback( void* data, dGeomID geom1, dGeomID geom2 );
	static	CCollisionContext*		mContextForCallback;

private:
	CHashCollidableContainer	mWorld;
	ICollisionListener*			mGlobalColListener;
	//TCollidePairSet				mCollidePairs;
};


// --------------------------------------------------------------------------


inline void CCollisionContext::addCollidable( CCollidable& c )
{
	mWorld.add( c );
}
inline void CCollisionContext::removeCollidable( CCollidable& c )
{
	mWorld.remove( c );
}
inline bool CCollisionContext::containsCollidable( CCollidable const& c ) const
{
	return mWorld.contains( c );
}


};


#endif
