// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "CollisionMesh.h"
#include <ode/dTriList.h>


using namespace dingus;

CCollisionMesh::~CCollisionMesh()
{
	if(mVertices)
		delete[] mVertices;
	if(mIndices)
		delete[] mIndices;
	if(mTriListData)
		dGeomTriListDeleteData(mTriListData);
}


void CCollisionMesh::begin( int numVerts, int numTris )
{
	if( mVertices )
		delete[] mVertices;
	if( mIndices )
		delete[] mIndices;
	if( mTriListData )
		dGeomTriListDeleteData(mTriListData);
	mNumIndices = numTris*3;
	mNumVertices = numVerts;
	mVertices = new SVector3[mNumVertices];
	mIndices = new int[mNumIndices];
}

void CCollisionMesh::end()
{
	assert( !mTriListData );
	mTriListData = dGeomTriListBuild(
		(const dcVector3*)mVertices, sizeof(dcVector3), mNumVertices,
		mIndices, sizeof(int), mNumIndices,
		3*sizeof(int) );
}


void CCollisionMesh::setTriangle( int i, int vertex1, int vertex2, int vertex3 )
{
	mIndices[i*3+0] = vertex1;
	mIndices[i*3+1] = vertex2;
	mIndices[i*3+2] = vertex3;
}
