// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __COLLISION_MESH_H
#define __COLLISION_MESH_H

#include "../math/Vector3.h"
#include "../math/Matrix4x4.h"

namespace dingus {


class CCollisionMesh {
public:
	CCollisionMesh() : mVertices(0), mIndices(0), mTriListData(0) { };
	~CCollisionMesh();
	
	void	begin( int numVerts, int numTris );
    void	setVertex( int i, const SVector3& v ) { mVertices[i] = v; }
    void	setTriangle( int i, int vertex1, int vertex2, int vertex3 );
	void	end();

	int		getNumVertices() const { return mNumVertices; }
	int		getNumIndices() const { return mNumIndices; }
	SVector3 const* getVertices() const { return mVertices; }
	int const* getIndices() const { return mIndices; }

	SMatrix4x4 const& getInertiaTensor() const { return mInertiaTensor; }
	SVector3 const& getMassCenter() const { return mMassCenter; }
	float getVolume() const { return mVolume; }
	void setMassProps( SMatrix4x4 const& inertiaTensor, SVector3 const& massCenter, float volume ) {
		mInertiaTensor = inertiaTensor;
		mMassCenter = massCenter;
		mVolume = volume;
	}

	void*	getTriListData() const { return mTriListData; }

private:
	// no copy
	CCollisionMesh(const CCollisionMesh&);
	void operator=(const CCollisionMesh&);

private:
	SVector3*	mVertices;
	int*		mIndices;
	int			mNumVertices;
	int			mNumIndices;

	SMatrix4x4	mInertiaTensor;
	SVector3	mMassCenter;
	float		mVolume;

	/** Pointer to data for ODE's dTriList. Actually it's OPCODE model with some addtn. stuff. */
	void*		mTriListData;
};


}; // namespace


#endif
