#include "dxTriList.h"

// Araz
#include <d3dx9math.h>
#include "../../math/Triangle.h"
// /Araz

// Araz: TBD: ODE in doubles, OPCODE in floats

#if 0

#define MAX_PAIRS 12

using dingus::STriangle;
using dingus::SLine3;
using dingus::SVector3;


int dCollideTLTL(dxGeom* TriList0, dxGeom* TriList1, int Flags, dContactGeom* Contacts, int Stride){
	// Araz
	dxTriList* tl0 = GetTL(TriList0);
	dxTriList* tl1 = GetTL(TriList1);
	// /Araz
	dxTriListData* TLData0 = GetTLData(TriList0);
	dxTriListData* TLData1 = GetTLData(TriList1);

	AABBTreeCollider& Collider = TLData0->aAABBTreeCollider;

	// Araz: pointers instead of callbacks
	Collider.SetPointers1( (const IndexedTriangle*)TLData1->Indices, (const Point*)TLData1->Vertices );
	//Collider.SetCallback1((OPC_CALLBACK)dxTriListData::FetchTriangleCB, (udword)TLData1);

	BVTCache Cache;
	Cache.Model0 = &TLData0->BVTree;
	Cache.Model1 = &TLData1->BVTree;
	Matrix4x4 aMatrix0, aMatrix1;
	MakeMatrix(TriList0, aMatrix0);
	MakeMatrix(TriList1, aMatrix1);
	Collider.Collide(Cache, &aMatrix0, &aMatrix1);

	int numPairs = Collider.GetNbPairs();
	if( numPairs != 0 ) {
		const Pair* pairs = Collider.GetPairs();

		// Araz: from Nebula
		// clamp number of collissions to a reasonable amount
		if( numPairs > MAX_PAIRS ) numPairs = MAX_PAIRS;
		
		const dVector3& TL0Pos = *(const dVector3*)dGeomGetPosition(TriList0);
		const dMatrix3& TL0Rot = *(const dMatrix3*)dGeomGetRotation(TriList0);
		const dVector3& TL1Pos = *(const dVector3*)dGeomGetPosition(TriList1);
		const dMatrix3& TL1Rot = *(const dMatrix3*)dGeomGetRotation(TriList1);

		// contact info holders
		SVector3	conPos(0,0,0);
		SVector3	conNormal(0,0,0);
		float		conDepth2 = 0.0f;

		int i;
		dVector3 tp[2][3];
		SLine3 l[2][3];
		STriangle t[2];
		bool intersects[2][3];
		float ipos[2][3];
		for( i = 0; i < numPairs; ++i ) {
			int j;
			// get the current contact triangles coordinates in world space
			FetchVertex(TLData0,pairs[i].id0,0,TL0Pos, TL0Rot, tp[0][0] );
			FetchVertex(TLData0,pairs[i].id0,1,TL0Pos, TL0Rot, tp[0][1] );
			FetchVertex(TLData0,pairs[i].id0,2,TL0Pos, TL0Rot, tp[0][2] );
			FetchVertex(TLData1,pairs[i].id1,0,TL1Pos, TL1Rot, tp[1][0] );
			FetchVertex(TLData1,pairs[i].id1,1,TL1Pos, TL1Rot, tp[1][1] );
			FetchVertex(TLData1,pairs[i].id1,2,TL1Pos, TL1Rot, tp[1][2] );
			
			// build mathlib triangles...
			t[0].set( tp[0][0], tp[0][1], tp[0][2] );
			t[1].set( tp[1][0], tp[1][1], tp[1][2] );

			// build the 3 lines for each triangle and do intersection
			l[0][0].set(t[0].getPoint0(), t[0].getPoint1());
			l[0][1].set(t[0].getPoint0(), t[0].getPoint2());
			l[0][2].set(t[0].getPoint1(), t[0].getPoint2());

			l[1][0].set(t[1].getPoint0(), t[1].getPoint1());
			l[1][1].set(t[1].getPoint0(), t[1].getPoint2());
			l[1][2].set(t[1].getPoint1(), t[1].getPoint2());

			// test triangle 0 lines against triangle 1
			// test triangle 1 lines against triangle 0
			for( j = 0; j < 3; ++j ) {
				intersects[0][j] = t[1].intersect2Sided(l[0][j], ipos[0][j]);
				intersects[1][j] = t[0].intersect2Sided(l[1][j], ipos[1][j]);
			}

			// get averaged intersection position, we use this as the contact point
			int numIsects = 0;
			SVector3 contact(0.0f, 0.0f, 0.0f);
			for( j = 0; j < 2; j++ ) {
				for( int k = 0; k < 3; k++ ) {
					if( intersects[j][k] ) {
						contact += l[j][k].interpolate( ipos[j][k] );
						numIsects++;
					}
				}
			}

			if( numIsects>0 ) {
				contact /= float(numIsects);
			} 
    
			// accumulate contact info
			conPos += contact;
			conNormal += t[0].getNormal();
			conNormal += t[1].getNormal();
			// TBD: depth
		}

		dContactGeom* dcontact = CONTACT(Flags, Contacts, 0, Stride);

		// average collide results
		float div = 1.0f / float(numPairs);
		conPos *= div;
		conNormal.normalize();

		dcontact->pos[0] = conPos.x;
		dcontact->pos[1] = conPos.y;
		dcontact->pos[2] = conPos.z;
		dcontact->pos[3] = 0.0f;

		dcontact->normal[0] = conNormal.x;
		dcontact->normal[1] = conNormal.y;
		dcontact->normal[2] = conNormal.z;
		dcontact->normal[3] = 0.0f;

		// TBD
		dcontact->depth = 0.1f;

		dcontact->g1 = TriList0;
		dcontact->g2 = TriList1;

		return 1;

		// Araz: end from Nebula
	}
	return 0;
}

#endif
