// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "VSKeyframeMeshRenderer.h"

#include "../renderer/RenderableBuffer.h"
#include "../utils/Errors.h"


using namespace dingus;


CVSKeyframe2MeshRenderer::CVSKeyframe2MeshRenderer(
	CRenderableIndexedBuffer& renderable,
	CD3DVertexDecl& vDecl, CEffectParams::TParamName blendParamName )
:	mVertexDecl(&vDecl), mBlendParamName( blendParamName ), mRenderable(&renderable)
{
	assert( mRenderable );
	mRenderable->getParams().addFloatRef( mBlendParamName, &mBlendParam );
}

void CVSKeyframe2MeshRenderer::render( CD3DXMesh& mesh0, CD3DXMesh& mesh1, float t )
{
	mRenderable->resetVBs();

	IDirect3DVertexBuffer9* vb = NULL;

	HRESULT hres;

	// set mesh 0
	hres = mesh0.getObject()->GetVertexBuffer( &vb );
	if( FAILED( hres ) ) { THROW_DXERROR( hres, "failed to obtain vertex buffer" ); }
	assert( vb );
	mBuffer0.setObject( vb );
	mRenderable->setVB( mBuffer0, 0 );
	mRenderable->setStride( mesh0.getObject()->GetNumBytesPerVertex(), 0 );
	vb->Release();

	// set mesh 1
	hres = mesh1.getObject()->GetVertexBuffer( &vb );
	if( FAILED( hres ) ) { THROW_DXERROR( hres, "failed to obtain vertex buffer" ); }
	assert( vb );
	mBuffer1.setObject( vb );
	mRenderable->setVB( mBuffer1, 1 );
	mRenderable->setStride( mesh1.getObject()->GetNumBytesPerVertex(), 1 );
	vb->Release();

	// other params from mesh 0
	IDirect3DIndexBuffer9* ib = NULL;
	hres = mesh0.getObject()->GetIndexBuffer( &ib );
	if( FAILED( hres ) ) { THROW_DXERROR( hres, "failed to obtain index buffer" ); }
	assert( ib );
	mIBuffer.setObject( ib );
	mRenderable->setIB( mIBuffer );
	ib->Release();

	mRenderable->setPrimType( D3DPT_TRIANGLELIST );
	mRenderable->setBaseVertex( 0 );
	mRenderable->setMinVertex( 0 );
	mRenderable->setNumVertices( mesh0.getObject()->GetNumVertices() );
	mRenderable->setStartIndex( 0 );
	mRenderable->setPrimCount( mesh0.getObject()->GetNumFaces() );

	mRenderable->setVertexDecl( mVertexDecl );

	mBlendParam = t;
}
