// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __VS_KEYFRAME_MESH_RENDERER_H
#define __VS_KEYFRAME_MESH_RENDERER_H

#include "../kernel/Proxies.h"
#include "../renderer/EffectParams.h"

namespace dingus {


class CRenderableIndexedBuffer;


class CVSKeyframe2MeshRenderer {
public:
	CVSKeyframe2MeshRenderer( CRenderableIndexedBuffer& renderable, CD3DVertexDecl& vDecl, CEffectParams::TParamName blendParamName );
	
	void render( CD3DXMesh& mesh0, CD3DXMesh& mesh1, float t );

private:
	CD3DVertexDecl*				mVertexDecl;
	CEffectParams::TParamName	mBlendParamName;
	float						mBlendParam;
	CRenderableIndexedBuffer*	mRenderable;
	CD3DVertexBuffer			mBuffer0;
	CD3DVertexBuffer			mBuffer1;
	CD3DIndexBuffer				mIBuffer;
};



}; // namespace


#endif
