// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __DYNAMIC_VB_MANAGER_H
#define __DYNAMIC_VB_MANAGER_H

#include "ManagedBuffer.h"
#include "VBChunk.h"
#include "../../resource/DeviceResource.h"

namespace dingus {


class CDynamicVBManager : public CManagedBuffer<CVBChunk, CD3DVertexBuffer>, public IDeviceResource {
public:
	enum { DEFAULT_CAPACITY = 2*1024*1024 }; // 2 megabytes
	static const DWORD		VB_USAGE;
	static const D3DPOOL	VB_POOL;

public:	
	CDynamicVBManager( int capacityBytes );
	virtual ~CDynamicVBManager();
	
	// IManagedResource
	virtual void createResource();
	virtual void activateResource();
	virtual void passivateResource();
	virtual void deleteResource();

protected:
	// interface for CManagedBuffer
	virtual byte* lockBuffer( int byteStart, int byteCount );

	CD3DVertexBuffer* allocateBuffer( int capacityBytes );

private:
	IDirect3DVertexBuffer9* createBuffer( int capacityBytes );
};


}; // namespace

#endif