// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __COMPOSITE_ACTION_H
#define __COMPOSITE_ACTION_H

#include "InputAction.h"


namespace dingus {


class CCompositeAction : public IInputAction {
public:
	typedef std::vector<IInputAction*>	TActionsVector;

public:

	void addAction( IInputAction& action ) { mActions.push_back(&action); }

	virtual void onInputEvent( CInputEvent const& event ) {
		TActionsVector::iterator it, itEnd = mActions.end();
		for( it = mActions.begin(); it != itEnd; ++it )
			(*it)->onInputEvent( event );
	}

private:
	TActionsVector	mActions;
};


}; // namespace

#endif
