// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __DYNAMIC_ACTION_H
#define __DYNAMIC_ACTION_H

#include "InputAction.h"

namespace dingus {


class CDynamicAction : public IInputAction {
public:
	CDynamicAction() : mCurrentAction(0) { };

	virtual void onInputEvent( CInputEvent const& event ) {
		if( !mCurrentAction )
			return;
		mCurrentAction->onInputEvent( event );
	}
	
	void setCurrentAction( IInputAction* action ) { mCurrentAction = action; };
	IInputAction* getCurrentAction() { return mCurrentAction; };

private:
	IInputAction*	mCurrentAction;
};


}; // namespace

#endif
