// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "InputBindings.h"

#include "InputAction.h"

using namespace dingus;


void CInputBindings::addBinding( CInputEvent::TSharedPtr const& event, IInputAction& action )
{
	mActions.insert( std::make_pair( event, &action ) );
}

void CInputBindings::removeBinding( CInputEvent::TSharedPtr const& event )
{
	mActions.erase( event );
}

IInputAction* CInputBindings::getBinding( CInputEvent::TSharedPtr const& event ) const
{
	TEventActionMap::const_iterator it = mActions.find( event );
	return (it==mActions.end()) ? NULL : it->second;
}
