// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __INPUT_BINDINGS_H
#define __INPUT_BINDINGS_H

#include "InputEvent.h"

namespace dingus {


class IInputAction;


class CInputBindings {
public:
	IInputAction* getBinding( CInputEvent::TSharedPtr const& event ) const;

	void addBinding( CInputEvent::TSharedPtr const& event, IInputAction& action );
	void removeBinding( CInputEvent::TSharedPtr const& event );

private:
	struct SEventComparator {
		bool operator() ( CInputEvent::TSharedPtr const& a, CInputEvent::TSharedPtr const& b ) const {
			return *a.get() < *b.get();
		};
	};

private:
	typedef std::map<CInputEvent::TSharedPtr,IInputAction*,SEventComparator>	TEventActionMap;

private:
	TEventActionMap	mActions;
};


}; // namespace

#endif
