// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __INPUT_CONTEXT_H
#define __INPUT_CONTEXT_H

#include "InputBindings.h"

namespace dingus {


class IController;
class IInputDevice;



class CInputContext {
public:
	typedef std::list<IInputDevice*> TDeviceContainer;
	typedef std::list<IController*> TControllerContainer;
	
public:
	void	addDevice( IInputDevice& inputDevice ) { mInputDevices.push_back(&inputDevice); }
	void	removeDevice( IInputDevice& inputDevice ) { mInputDevices.remove(&inputDevice); }
	TDeviceContainer& getDevices() { return mInputDevices; }

	const CInputBindings& getBindings() const { return mInputBindings; };
	CInputBindings& getBindings() { return mInputBindings; };

	void	addController( IController& controller ) { mControllers.push_back(&controller); }
	void	removeController( IController& controller ) { mControllers.remove(&controller); }
	TControllerContainer& getControllers() { return mControllers; }
	
private:
	TDeviceContainer		mInputDevices;
	CInputBindings			mInputBindings;
	TControllerContainer	mControllers;
};


}; // namespace

#endif
