// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "InputStage.h"

#include "InputAction.h"
#include "Controller.h"
#include "InputDevice.h"

using namespace dingus;



void CInputStage::perform()
{
	assert( mCtx );

	//
	// devices

	CInputContext::TDeviceContainer::iterator dit, ditEnd = mCtx->getDevices().end();
	for( dit = mCtx->getDevices().begin(); dit != ditEnd; ++dit ) {
		IInputDevice* device = *dit;
		assert( device );

		CInputEvents polled( device->poll() );
		CInputEvents::TEventsVector::const_iterator it, itEnd = polled.getEvents().end();
		for( it = polled.getEvents().begin(); it!=itEnd; ++it ) {
			const CInputEvent::TSharedPtr& event = *it;
			assert( event.get() );
			IInputAction* action = mCtx->getBindings().getBinding( event );
			if( action )
				action->onInputEvent( *event );
		}
	}

	//
	// controllers

	CInputContext::TControllerContainer::iterator cit, citEnd = mCtx->getControllers().end();
	for( cit = mCtx->getControllers().begin(); cit!=citEnd; ++cit ) {
		assert( *cit );
		(*cit)->onProcessTime();
	}
}
