// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __INPUT_STAGE_H
#define __INPUT_STAGE_H

#include "../pipeline/PipelineStage.h"
#include "InputContext.h"

namespace dingus {



class CInputStage : public IPipelineStage {
public:
	explicit CInputStage( CInputContext& ctx ) : mCtx(&ctx) { };
	virtual ~CInputStage() { };

	// IPipelineStage
	virtual void perform();

	void setContext( CInputContext& ctx ) { mCtx = &ctx; };
	CInputContext* getContext() const { return mCtx; };
	
private:
	CInputContext*	mCtx;
};


}; // namespace

#endif
