// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __FRAME_NUMBER_H
#define __FRAME_NUMBER_H


class CFrameNumber {
public:
	explicit CFrameNumber( int frameNumber = -1 )
		: mFrameNumber( frameNumber ) { };

	bool operator==( CFrameNumber const& r ) const { return mFrameNumber == r.mFrameNumber; }
	
	void increase( int amount = 1 ) { mFrameNumber += amount; };
	
	int getFrameNumber() const { return mFrameNumber; };
	
private:
	int	mFrameNumber;
};

#endif
