// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#include "../stdafx.h"
#pragma hdrstop

#include "LuaIterator.h"

using namespace dingus;

CLuaArrayIterator::CLuaArrayIterator( CLuaValue& val )
:	mLua(&val.getLua()),
	mValue(&val),
	mFetchedElem(val.getElement(1)),
	mIndex(1)
{
}

CLuaArrayIterator::~CLuaArrayIterator()
{
	mLua->discard();
}

bool CLuaArrayIterator::hasNext() const
{
	bool ok = !mValue->getElement(mIndex).isNil();
	mLua->discard();
	return ok;
}

CLuaValue& CLuaArrayIterator::next()
{
	assert( hasNext() );
	// first elem?
	if( mIndex == 1 ) {
		++mIndex;
	} else {
		// discard last element fetched
		mLua->discard();
		// fetch new element
		mFetchedElem = mValue->getElement(mIndex);
		++mIndex;
	}
	return mFetchedElem;
}
