// --------------------------------------------------------------------------
// Dingus project - a collection of subsystems for game/graphics applications
// Developed by nesnausk! team: www.nesnausk.org
// --------------------------------------------------------------------------

#ifndef __MATH_AABOX_H
#define __MATH_AABOX_H

#include "Vector3.h"
#include "Constants.h"

namespace dingus {


/**
 *  Axis aligned box.
 *
 *  Essentially two SVector3's - one for minimum, one for maximum.
 */
class CAABox {
public:
	/// Initializes minimum to big numbers, maximum to big negative numbers.
	CAABox()
	:	mMin(DINGUS_BIG_FLOAT,DINGUS_BIG_FLOAT,DINGUS_BIG_FLOAT),
		mMax(-DINGUS_BIG_FLOAT,-DINGUS_BIG_FLOAT,-DINGUS_BIG_FLOAT) { }

	/// Gets minimum vector.
	const dingus::SVector3& getMin() const { return mMin; }
	/// Gets maximum vector.
	const dingus::SVector3& getMax() const { return mMax; }

	/// Extends a box to include point
	void	extend( const SVector3& p ) {
		if( p.x < mMin.x ) mMin.x = p.x;
		if( p.y < mMin.y ) mMin.y = p.y;
		if( p.z < mMin.z ) mMin.z = p.z;
		if( p.x > mMax.x ) mMax.x = p.x;
		if( p.y > mMax.y ) mMax.y = p.y;
		if( p.z > mMax.z ) mMax.z = p.z;
	}
	/// Extends a box to include point and some more space
	void	extend( const SVector3& p, float more ) {
		if( p.x-more < mMin.x ) mMin.x = p.x-more;
		if( p.y-more < mMin.y ) mMin.y = p.y-more;
		if( p.z-more < mMin.z ) mMin.z = p.z-more;
		if( p.x+more > mMax.x ) mMax.x = p.x+more;
		if( p.y+more > mMax.y ) mMax.y = p.y+more;
		if( p.z+more > mMax.z ) mMax.z = p.z+more;
	}

	/// Tests if a point is inside this box
	bool isInside( const SVector3& p ) const {
		return
			p.x>=mMin.x && p.x<=mMax.x &&
			p.y>=mMin.y && p.y<=mMax.y &&
			p.z>=mMin.z && p.z<=mMax.z;
	}

private:
	dingus::SVector3	mMin;
	dingus::SVector3	mMax;
};


}; // namespace


#endif
